/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.net.SocketStreamDecorationStrategy;
import org.openorb.util.ConfigUtils;
import org.openorb.util.logger.LoggerTeam;

public final class PriorityBoostingSocketStreamDecorationStrategy
implements SocketStreamDecorationStrategy {
    private final int m_minPriority;

    public PriorityBoostingSocketStreamDecorationStrategy(int minPriority) {
        this.m_minPriority = minPriority;
    }

    public InputStream decorate(Socket socket, InputStream stream) throws IOException {
        return new MinPriorityInputStream(stream);
    }

    public OutputStream decorate(Socket socket, OutputStream stream) throws IOException {
        return stream;
    }

    private final class MinPriorityInputStream
    extends FilterInputStream {
        public MinPriorityInputStream(InputStream in) {
            super(in);
        }

        private int setPriority(Thread thread) {
            int oldPriority = thread.getPriority();
            if (oldPriority < PriorityBoostingSocketStreamDecorationStrategy.this.m_minPriority) {
                thread.setPriority(PriorityBoostingSocketStreamDecorationStrategy.this.m_minPriority);
            }
            return oldPriority;
        }

        private void restorePriority(Thread thread, int oldPriority) {
            if (oldPriority < PriorityBoostingSocketStreamDecorationStrategy.this.m_minPriority) {
                thread.setPriority(oldPriority);
            }
        }

        public int read() throws IOException {
            Thread thread = Thread.currentThread();
            int oldPriority = this.setPriority(thread);
            try {
                int n = super.read();
                Object var5_4 = null;
                this.restorePriority(thread, oldPriority);
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.restorePriority(thread, oldPriority);
                throw throwable;
            }
        }

        public int read(byte[] buffer) throws IOException {
            Thread thread = Thread.currentThread();
            int oldPriority = this.setPriority(thread);
            try {
                int n = super.read(buffer);
                Object var6_5 = null;
                this.restorePriority(thread, oldPriority);
                return n;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.restorePriority(thread, oldPriority);
                throw throwable;
            }
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            Thread thread = Thread.currentThread();
            int oldPriority = this.setPriority(thread);
            try {
                int n = super.read(buffer, offset, length);
                Object var8_7 = null;
                this.restorePriority(thread, oldPriority);
                return n;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.restorePriority(thread, oldPriority);
                throw throwable;
            }
        }
    }

    public static final class Factory
    implements SocketStreamDecorationStrategy.Factory {
        public SocketStreamDecorationStrategy create(LoggerTeam logger, ORBLoader loader, String prefix) {
            String boostReceivePriorityName = ConfigUtils.prefixName((String)prefix, (String)"boostReceivePriority");
            if (loader.getBooleanProperty(boostReceivePriorityName, false)) {
                return new PriorityBoostingSocketStreamDecorationStrategy(10);
            }
            return null;
        }
    }
}

