/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.pi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.openorb.orb.pi.IORManager;
import org.openorb.orb.policy.PolicyReconciler;

public class ComponentSet
extends LocalObject
implements IORInfo {
    private ORB m_orb;
    private PolicyReconciler m_orb_reconciler;
    private DomainManager[] m_domain_managers;
    private PolicyManagerOperations m_oa_policies;
    private Map m_profile_components = new HashMap();

    public ComponentSet(ORB orb, PolicyManagerOperations oaPolicies, DomainManager[] domainManagers) {
        this.m_orb = orb;
        org.openorb.orb.core.ORB openorb = (org.openorb.orb.core.ORB)orb;
        this.m_orb_reconciler = (PolicyReconciler)openorb.getFeature("PolicyReconciler");
        this.m_oa_policies = oaPolicies;
        this.m_domain_managers = domainManagers;
    }

    public void interception_point() {
        this.m_profile_components.clear();
        IORManager ior_manager = (IORManager)((org.openorb.orb.core.ORB)this.m_orb).getFeature("IORInterceptorManager");
        if (ior_manager != null) {
            ior_manager.establish_components(this);
        }
    }

    public Policy get_effective_policy(int type) {
        int[] types;
        Policy[] policies;
        Policy oa_policy = null;
        if (this.m_oa_policies != null && (policies = this.m_oa_policies.get_policy_overrides(types = new int[]{type})) != null && policies.length > 0) {
            oa_policy = policies[0];
        }
        return this.m_orb_reconciler.reconcile_policies(type, null, oa_policy, this.m_domain_managers);
    }

    public void add_ior_component(TaggedComponent component) {
        this.add_ior_component_to_profile(component, 1);
    }

    public void add_ior_component_to_profile(TaggedComponent component, int profile_id) {
        Map map = this.m_profile_components;
        synchronized (map) {
            ArrayList<TaggedComponent> components = (ArrayList<TaggedComponent>)this.m_profile_components.get(new Integer(profile_id));
            if (components == null) {
                components = new ArrayList<TaggedComponent>();
                this.m_profile_components.put(new Integer(profile_id), components);
            }
            if (component != null) {
                components.add(component);
            }
        }
    }

    public TaggedComponent[] getComponents(int profile_id) {
        Map map = this.m_profile_components;
        synchronized (map) {
            ArrayList list = (ArrayList)this.m_profile_components.get(new Integer(profile_id));
            if (list == null) {
                TaggedComponent[] taggedComponentArray = new TaggedComponent[]{};
                return taggedComponentArray;
            }
            TaggedComponent[] tagged = new TaggedComponent[list.size()];
            list.toArray(tagged);
            TaggedComponent[] taggedComponentArray = tagged;
            return taggedComponentArray;
        }
    }
}

