/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.pi;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.core.SystemExceptionHelper;
import org.openorb.orb.pi.ClientManager;
import org.openorb.orb.pi.CurrentImpl;
import org.openorb.orb.pi.RequestCallback;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;

public class SimpleClientManager
implements ClientManager {
    private ClientRequestInterceptor[] m_list = null;
    private CurrentImpl m_current;
    private Logger m_logger;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;

    public SimpleClientManager(ClientRequestInterceptor[] list, CurrentImpl current) {
        this.m_list = list;
        this.m_current = current;
        this.m_logger = ((ORBSingleton)current._orb()).getLogger();
    }

    public void send_request(ClientRequestInfo info, RequestCallback cb) {
        int index = 0;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index < this.m_list.length) {
                this.m_list[index].send_request(info);
                this.m_current.remove();
                ++index;
            }
        }
        catch (ForwardRequest ex) {
            this.m_current.remove();
            cb.reply_location_forward(ex.forward, false);
            this.receive_other_point(index - 1, info, cb);
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause((SystemException)new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            ex.completed = CompletionStatus.COMPLETED_NO;
            cb.reply_system_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_runtime_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_error(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void send_poll(ClientRequestInfo info, RequestCallback cb) {
        int index = 0;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index < this.m_list.length) {
                this.m_list[index].send_poll(info);
                this.m_current.remove();
                ++index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause((SystemException)new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_runtime_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_error(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void receive_reply(ClientRequestInfo info, RequestCallback cb) {
        int index = this.m_list.length - 1;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index >= 0) {
                this.m_list[index].receive_reply(info);
                this.m_current.remove();
                --index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_YES) {
                ex = ExceptionTool.initCause((SystemException)new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_runtime_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_error(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void receive_exception(ClientRequestInfo info, RequestCallback cb) {
        CurrentOperations table = this.m_current.remove();
        this.receive_exception_point(this.m_list.length - 1, info, cb);
        this.m_current.set(table);
    }

    private void receive_exception_point(int index, ClientRequestInfo info, RequestCallback cb) {
        if (index < 0) {
            return;
        }
        CompletionStatus status = info.reply_status() == 1 ? SystemExceptionHelper.extract((Any)info.received_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (index >= 0) {
            block11: {
                try {
                    this.m_list[index].receive_exception(info);
                }
                catch (SystemException ex) {
                    if (ex.completed != status) {
                        ex = ExceptionTool.initCause((SystemException)new INTERNAL(0, status), (Throwable)ex);
                    }
                    cb.reply_system_exception(ex);
                }
                catch (RuntimeException ex) {
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
                    }
                    cb.reply_runtime_exception(ex);
                }
                catch (Error ex) {
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
                    }
                    cb.reply_error(ex);
                }
                catch (ForwardRequest ex) {
                    this.m_current.remove();
                    if (status != CompletionStatus.COMPLETED_YES) {
                        cb.reply_system_exception(ExceptionTool.initCause((SystemException)new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)ex));
                        break block11;
                    }
                    cb.reply_location_forward(ex.forward, false);
                    this.receive_other_point(index - 1, info, cb);
                    return;
                }
                this.m_current.remove();
            }
            --index;
        }
    }

    public void receive_other(ClientRequestInfo info, RequestCallback cb) {
        CurrentOperations table = this.m_current.remove();
        this.receive_other_point(this.m_list.length - 1, info, cb);
        this.m_current.set(table);
    }

    private void receive_other_point(int index, ClientRequestInfo info, RequestCallback cb) {
        if (index < 0) {
            return;
        }
        try {
            while (index >= 0) {
                try {
                    this.m_list[index].receive_other(info);
                }
                catch (ForwardRequest ex) {
                    cb.reply_location_forward(ex.forward, false);
                }
                this.m_current.remove();
                --index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause((SystemException)new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_runtime_exception(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ex.toString());
            }
            cb.reply_error(ex);
            this.receive_exception_point(index - 1, info, cb);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

