/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.policy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableInterceptor.PolicyFactory;
import org.openorb.orb.policy.PolicyFactoryManager;
import org.openorb.orb.policy.PolicyReconciler;
import org.openorb.orb.policy.PolicySet;
import org.openorb.orb.policy.PolicySetManager;
import org.openorb.util.NumberCache;

public class ORBPolicyManagerImpl
extends LocalObject
implements PolicyManager,
PolicyReconciler,
PolicyFactoryManager,
PolicySetManager,
PolicyFactory {
    private PolicySet m_policy_set = null;
    private Map m_factories;
    private List m_domain_sets = new ArrayList(2);
    private Map m_policy_reconcilers = null;

    public ORBPolicyManagerImpl() {
        this.add_policy_domain();
        this.add_policy_domain();
    }

    public void set_policy_overrides(Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        if (this.m_policy_set == null) {
            this.m_policy_set = new PolicySet(null, -1);
        }
        this.m_policy_set.set_policy_overrides(policies, set_add);
    }

    public Policy[] get_policy_overrides(int[] ts) {
        if (this.m_policy_set == null) {
            return new Policy[0];
        }
        return this.m_policy_set.get_policy_overrides(ts);
    }

    public PolicyManagerOperations create_policy_set() {
        return new PolicySet(null, -1);
    }

    public PolicyManagerOperations create_policy_set(int policy_domain) {
        return new PolicySet(this, policy_domain);
    }

    public void add_invalid_policy_type(int policy_domain, int policy_type) {
        ((Set)this.m_domain_sets.get(policy_domain)).add(NumberCache.getInteger((int)policy_type));
    }

    public int add_policy_domain() {
        int ret = this.m_domain_sets.size();
        this.m_domain_sets.add(new TreeSet());
        return ret;
    }

    public Policy reconcile_policies(int policy_type, Policy client_policy, Policy profile_policy, DomainManager[] domain_managers) {
        PolicyReconciler recon;
        if (client_policy != null && policy_type != client_policy.policy_type() || profile_policy != null && policy_type != profile_policy.policy_type()) {
            String msg = "Policy types don't match: ";
            if (client_policy != null && policy_type != client_policy.policy_type()) {
                msg = msg + "policy type '" + policy_type + "' and client policy '" + client_policy.policy_type() + "'.";
            }
            if (profile_policy != null && policy_type != profile_policy.policy_type()) {
                msg = msg + "policy type '" + policy_type + "' and profile policy '" + profile_policy.policy_type() + "'.";
            }
            throw new INV_POLICY(msg, 1146056718, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.m_policy_reconcilers != null && (recon = (PolicyReconciler)this.m_policy_reconcilers.get(NumberCache.getInteger((int)policy_type))) != null) {
            return recon.reconcile_policies(policy_type, client_policy, profile_policy, domain_managers);
        }
        if (client_policy == null && profile_policy != null) {
            return profile_policy;
        }
        if (client_policy != null && profile_policy == null) {
            return client_policy;
        }
        if (client_policy == null && profile_policy == null && domain_managers != null) {
            Policy ret = null;
            int i = 0;
            while (i < domain_managers.length) {
                try {
                    ret = domain_managers[i].get_domain_policy(policy_type);
                    break;
                }
                catch (INV_POLICY ex) {
                    ++i;
                }
            }
            while (i < domain_managers.length) {
                try {
                    domain_managers[i].get_domain_policy(policy_type);
                    ret = null;
                    break;
                }
                catch (INV_POLICY ex) {
                    ++i;
                }
            }
            if (ret != null) {
                return ret;
            }
        }
        throw new INV_POLICY("Could't find a match for policy type '" + policy_type + "'.", 1146056718, CompletionStatus.COMPLETED_MAYBE);
    }

    public void add_policy_reconciler(int policy_type, PolicyReconciler reconciler) {
        if (this.m_policy_reconcilers == null) {
            this.m_policy_reconcilers = new HashMap();
        }
        if (reconciler == null) {
            this.m_policy_reconcilers.remove(NumberCache.getInteger((int)policy_type));
        } else {
            this.m_policy_reconcilers.put(NumberCache.getInteger((int)policy_type), reconciler);
        }
    }

    boolean invalid_policy(int policy_domain, int policy_type) {
        if (policy_domain < 0) {
            return false;
        }
        return ((Set)this.m_domain_sets.get(policy_domain)).contains(NumberCache.getInteger((int)policy_type));
    }

    public void add_policy_factory(int type, PolicyFactory factory) {
        if (this.m_factories == null) {
            this.m_factories = new HashMap();
        }
        if (factory == this) {
            return;
        }
        if (factory == null) {
            this.m_factories.remove(NumberCache.getInteger((int)type));
        } else {
            this.m_factories.put(NumberCache.getInteger((int)type), factory);
        }
    }

    public Policy create_policy(int type, Any val) throws PolicyError {
        PolicyFactory factory = (PolicyFactory)this.m_factories.get(NumberCache.getInteger((int)type));
        if (factory == null) {
            throw new PolicyError(3);
        }
        return factory.create_policy(type, val);
    }
}

