/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.policy;

import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.CORBA.SetOverrideType;
import org.openorb.orb.policy.ORBPolicyManagerImpl;
import org.openorb.util.NumberCache;

class PolicySet
implements PolicyManagerOperations {
    private static final Policy[] EMPTY = new Policy[0];
    private int m_policy_domain;
    private ORBPolicyManagerImpl m_manager;
    private Map m_policy_set;

    public PolicySet(ORBPolicyManagerImpl manager, int policyDomain) {
        this.m_manager = policyDomain < 0 ? null : manager;
        this.m_policy_domain = policyDomain;
    }

    public void set_policy_overrides(Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        if (this.m_manager != null && policies != null) {
            int invalid = 0;
            int[] invalids = null;
            int i = 0;
            while (i < policies.length) {
                if (policies[i] != null && this.m_manager.invalid_policy(this.m_policy_domain, policies[i].policy_type())) {
                    if (invalids == null) {
                        invalids = new int[policies.length - i];
                    }
                    invalids[invalid++] = i;
                }
                ++i;
            }
            if (invalid > 0) {
                InvalidPolicies pol = new InvalidPolicies();
                pol.indices = new short[invalid];
                int i2 = 0;
                while (i2 < invalid) {
                    pol.indices[i2] = (short)invalids[i2];
                    ++i2;
                }
                throw pol;
            }
        }
        PolicySet policySet = this;
        synchronized (policySet) {
            if (this.m_policy_set == null) {
                this.m_policy_set = new HashMap();
            } else if (set_add == SetOverrideType.SET_OVERRIDE) {
                this.m_policy_set.clear();
            }
            if (policies == null || policies.length == 0) {
                return;
            }
            int i = 0;
            while (i < policies.length) {
                if (policies[i] != null) {
                    this.m_policy_set.put(NumberCache.getInteger((int)policies[i].policy_type()), policies[i]);
                }
                ++i;
            }
        }
    }

    public Policy[] get_policy_overrides(int[] ts) {
        Policy[] ret;
        int fill;
        PolicySet policySet = this;
        synchronized (policySet) {
            if (this.m_policy_set == null) {
                Policy[] policyArray = EMPTY;
                return policyArray;
            }
            if (ts == null || ts.length == 0) {
                Policy[] active = new Policy[this.m_policy_set.size()];
                Policy[] policyArray = active = this.m_policy_set.values().toArray(active);
                return policyArray;
            }
            fill = 0;
            ret = new Policy[ts.length];
            int i = 0;
            while (i < ts.length) {
                ret[fill] = (Policy)this.m_policy_set.get(NumberCache.getInteger((int)ts[i]));
                if (ret[fill] != null) {
                    ++fill;
                }
                ++i;
            }
        }
        if (fill != ret.length) {
            Policy[] tmp = new Policy[fill];
            System.arraycopy(ret, 0, tmp, 0, fill);
            ret = tmp;
        }
        return ret;
    }
}

