/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import org.openorb.orb.rmi.DeserializationKernel;
import org.openorb.orb.rmi.DeserializationKernelIBM;
import org.openorb.orb.rmi.DeserializationKernelIBM14;
import org.openorb.orb.rmi.DeserializationKernelNative;
import org.openorb.orb.rmi.DeserializationKernelSun;
import org.openorb.orb.rmi.DeserializationKernelSun15;
import org.openorb.orb.rmi.LazyInitDeserializationKernel;
import org.openorb.orb.rmi.NullDeserializationKernel;

public final class DeserializationKernelFactory {
    private static DeserializationKernel s_kernel = null;
    private static String s_deserializationEngine = "lazy:auto";
    private static final String LAZY_PREFIX = "lazy:";

    private DeserializationKernelFactory() {
    }

    public static void setDeserializationEngine(String deserializationEngine) {
        s_deserializationEngine = deserializationEngine;
    }

    public static synchronized DeserializationKernel retrieveDeserializationKernel() {
        if (s_kernel != null) {
            return s_kernel;
        }
        if (s_deserializationEngine.startsWith(LAZY_PREFIX) && s_deserializationEngine.length() > LAZY_PREFIX.length()) {
            String delegateShortName = s_deserializationEngine.substring(LAZY_PREFIX.length());
            LazyInitDeserializationKernel.setDelegateName(delegateShortName);
            s_kernel = new LazyInitDeserializationKernel();
        } else {
            s_kernel = DeserializationKernelFactory.createDeserializationKernel(s_deserializationEngine);
        }
        return s_kernel;
    }

    static DeserializationKernel createDeserializationKernel(String deserializationEngine) {
        if ("auto".equals(deserializationEngine)) {
            return DeserializationKernelFactory.createAutoDeserializationKernel();
        }
        if ("native".equals(deserializationEngine)) {
            return new DeserializationKernelNative();
        }
        if ("none".equals(deserializationEngine)) {
            return new NullDeserializationKernel();
        }
        throw new IllegalArgumentException("unsupported iiop.deserializationEngine '" + deserializationEngine + "', must be 'auto', 'native' or 'none'");
    }

    private static DeserializationKernel createAutoDeserializationKernel() {
        if (DeserializationKernelSun15.isSupportedPlatform()) {
            return new DeserializationKernelSun15();
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass("com.sun.corba.se.internal.io.IIOPInputStream");
            return new DeserializationKernelSun();
        }
        catch (ClassNotFoundException ex) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("com.ibm.rmi.io.JNIReflectField");
                return new DeserializationKernelIBM();
            }
            catch (ClassNotFoundException ex2) {
                String os_name = System.getProperty("os.name");
                String vm_version = System.getProperty("java.vm.version");
                if (!os_name.equalsIgnoreCase("AIX") || !vm_version.startsWith("1.4.")) {
                    try {
                        Thread.currentThread().getContextClassLoader().loadClass("com.ibm.rmi.io.PureReflectField");
                        return new DeserializationKernelIBM14();
                    }
                    catch (ClassNotFoundException ex3) {}
                } else {
                    return new DeserializationKernelNative();
                }
                String vmName = System.getProperty("java.vm.name");
                String vmVersion = System.getProperty("java.vm.version");
                String vmVendor = System.getProperty("java.vm.vendor");
                throw new Error("Unknown VM and iiop.deserializationEngine set to 'auto'. RMIoverIIOP will not work with this VM (" + vmName + ' ' + vmVersion + ", " + vmVendor + "). Please try the native engine or " + "contact support at openorb-users@lists.sf.net.");
            }
        }
    }
}

