/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openorb.orb.rmi.DeserializationKernel;
import org.openorb.util.CharacterCache;
import org.openorb.util.NumberCache;

public class DeserializationKernelIBM14
implements DeserializationKernel {
    private static final String REFLECT_FIELD_CLASS = "com.ibm.rmi.io.PureReflectField";
    private static final boolean LIBORB_LOADED = DeserializationKernelIBM14.loadORBLibrary();
    private static final Method ALLOCATE_NEW_OBJECT = DeserializationKernelIBM14.getPrivateMethod("java.io.ObjectStreamClass", "allocateNewObject", new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = DeserializationKernelIBM14.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Class == null ? (class$java$lang$Class = DeserializationKernelIBM14.class$("java.lang.Class")) : class$java$lang$Class});
    private static final Constructor REFLECT_FIELD_CONSTRUCTOR = DeserializationKernelIBM14.getReflectFieldConstructor();
    private static final Method SET = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "set", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object});
    private static final Method SET_BOOLEAN = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setBoolean", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Boolean.TYPE});
    private static final Method SET_BYTE = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setByte", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Byte.TYPE});
    private static final Method SET_CHAR = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setChar", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Character.TYPE});
    private static final Method SET_SHORT = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setShort", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Short.TYPE});
    private static final Method SET_INT = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setInt", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE});
    private static final Method SET_LONG = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setLong", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE});
    private static final Method SET_FLOAT = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setFloat", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Float.TYPE});
    private static final Method SET_DOUBLE = DeserializationKernelIBM14.getPublicMethod("com.ibm.rmi.io.PureReflectField", "setDouble", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = DeserializationKernelIBM14.class$("java.lang.Object")) : class$java$lang$Object, Double.TYPE});
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$reflect$Field;

    DeserializationKernelIBM14() {
        if (ALLOCATE_NEW_OBJECT == null) {
            throw new Error("Unable to get method 'allocateNewObject' from library!");
        }
        Object dummy = null;
        try {
            dummy = this.allocateNewObject(class$java$lang$String == null ? (class$java$lang$String = DeserializationKernelIBM14.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DeserializationKernelIBM14.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Throwable th) {
            throw new Error("Unable to execute the method 'allocateNewObject' from library! (" + th + ")");
        }
    }

    private static boolean loadORBLibrary() {
        boolean bSuccess = false;
        try {
            Class<?> clz = Class.forName("com.ibm.jvm.ExtendedSystem");
            bSuccess = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return bSuccess;
    }

    private static Constructor getReflectFieldConstructor() {
        Constructor<?> result = null;
        try {
            Class<?> clz = Class.forName(REFLECT_FIELD_CLASS);
            result = clz.getConstructor(class$java$lang$reflect$Field == null ? (class$java$lang$reflect$Field = DeserializationKernelIBM14.class$("java.lang.reflect.Field")) : class$java$lang$reflect$Field);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private static Method getPrivateMethod(String className, String methodName, Class[] params) {
        Method method = null;
        try {
            Class<?> clz = Class.forName(className);
            method = clz.getDeclaredMethod(methodName, params);
            ((AccessibleObject)method).setAccessible(true);
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Couldn't find class '" + className + "'");
        }
        catch (NoSuchMethodException ex) {
            throw new Error("Couldn't find method '" + methodName + "'");
        }
        catch (Throwable th) {
            throw new Error("An unexpected error occured! " + th);
        }
        return method;
    }

    private static Method getPublicMethod(String className, String methodName, Class[] params) {
        Method method = null;
        try {
            Class<?> clz = Class.forName(className);
            method = clz.getDeclaredMethod(methodName, params);
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Couldn't find class '" + className + "'");
        }
        catch (NoSuchMethodException ex) {
            throw new Error("Couldn't find method '" + methodName + "'");
        }
        catch (Throwable th) {
            throw new Error("An unexpected error occured! " + th);
        }
        return method;
    }

    private void invokeSetMethod(Class c, String n, Method m, Object o, Object v) {
        Field fld = null;
        try {
            fld = c.getDeclaredField(n);
        }
        catch (Exception ex) {
            throw new Error("Unexpected exception (" + ex + ")");
        }
        Object jniReflectFieldObj = null;
        try {
            jniReflectFieldObj = REFLECT_FIELD_CONSTRUCTOR.newInstance(fld);
        }
        catch (Exception ex) {
            throw new Error("Unexpected exception (" + ex + ")");
        }
        try {
            m.invoke(jniReflectFieldObj, o, v);
        }
        catch (Exception ex) {
            throw new Error("Unexpected exception (" + ex + ")");
        }
    }

    public Object allocateNewObject(Class c, Class base) throws InstantiationException, IllegalAccessException {
        try {
            return ALLOCATE_NEW_OBJECT.invoke(null, c, base);
        }
        catch (InvocationTargetException ex) {
            throw new Error("Unexpected exception (" + ex.getTargetException() + ")");
        }
    }

    public void setObjectField(Class c, String n, Object o, Object v) {
        this.invokeSetMethod(c, n, SET, o, v);
    }

    public void setBooleanField(Class c, String n, Object o, boolean v) {
        this.invokeSetMethod(c, n, SET_BOOLEAN, o, v ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByteField(Class c, String n, Object o, byte v) {
        this.invokeSetMethod(c, n, SET_BYTE, o, NumberCache.getByte((byte)v));
    }

    public void setCharField(Class c, String n, Object o, char v) {
        this.invokeSetMethod(c, n, SET_CHAR, o, CharacterCache.getCharacter((char)v));
    }

    public void setShortField(Class c, String n, Object o, short v) {
        this.invokeSetMethod(c, n, SET_SHORT, o, NumberCache.getShort((short)v));
    }

    public void setIntField(Class c, String n, Object o, int v) {
        this.invokeSetMethod(c, n, SET_INT, o, NumberCache.getInteger((int)v));
    }

    public void setLongField(Class c, String n, Object o, long v) {
        this.invokeSetMethod(c, n, SET_LONG, o, NumberCache.getLong((long)v));
    }

    public void setFloatField(Class c, String n, Object o, float v) {
        this.invokeSetMethod(c, n, SET_FLOAT, o, NumberCache.getFloat((float)v));
    }

    public void setDoubleField(Class c, String n, Object o, double v) {
        this.invokeSetMethod(c, n, SET_DOUBLE, o, NumberCache.getDouble((double)v));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

