/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.openorb.orb.rmi.DeserializationKernel;

public class DeserializationKernelNative
implements DeserializationKernel {
    private static final boolean LIBORB_LOADED = DeserializationKernelNative.loadORBLibrary();
    private static final HashMap CLASS_FIELD_CACHE = new HashMap();

    private static boolean loadORBLibrary() {
        boolean bSuccess = false;
        try {
            System.loadLibrary("openorb");
            bSuccess = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bSuccess;
    }

    private static String getCachedSignature(Class clazz, String fldName) {
        String result = null;
        HashMap<String, String> fieldMap = null;
        HashMap hashMap = CLASS_FIELD_CACHE;
        synchronized (hashMap) {
            fieldMap = (HashMap<String, String>)CLASS_FIELD_CACHE.get(clazz);
            if (fieldMap == null) {
                fieldMap = new HashMap<String, String>();
                CLASS_FIELD_CACHE.put(clazz, fieldMap);
            }
        }
        result = (String)fieldMap.get(fldName);
        if (result == null && (result = DeserializationKernelNative.getSignature(clazz, fldName)) != null) {
            HashMap<String, String> hashMap2 = fieldMap;
            synchronized (hashMap2) {
                fieldMap.put(fldName, result);
            }
        }
        return result;
    }

    private static String getSignature(Class clazz, String fldName) {
        Class<?> clz = null;
        if (fldName != null && fldName.length() > 0) {
            try {
                Field fld = clazz.getDeclaredField(fldName);
                clz = fld.getType();
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        } else {
            clz = clazz;
        }
        String type = null;
        if (clz.isPrimitive()) {
            if (clz == Integer.TYPE) {
                type = "I";
            } else if (clz == Byte.TYPE) {
                type = "B";
            } else if (clz == Long.TYPE) {
                type = "J";
            } else if (clz == Float.TYPE) {
                type = "F";
            } else if (clz == Double.TYPE) {
                type = "D";
            } else if (clz == Short.TYPE) {
                type = "S";
            } else if (clz == Character.TYPE) {
                type = "C";
            } else if (clz == Boolean.TYPE) {
                type = "Z";
            } else if (clz == Void.TYPE) {
                type = "V";
            }
        } else if (clz.isArray()) {
            Class<?> cl = clz;
            int dim = 0;
            while (cl.isArray()) {
                ++dim;
                cl = cl.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < dim) {
                sb.append("[");
                ++i;
            }
            sb.append(DeserializationKernelNative.getSignature(cl, null));
            type = sb.toString();
        } else {
            type = "L" + clz.getName().replace('.', '/') + ";";
        }
        return type;
    }

    public Object allocateNewObject(Class aclass, Class initClass) {
        return DeserializationKernelNative.nativeAllocateNewObject(aclass, initClass);
    }

    private static native Object nativeAllocateNewObject(Class var0, Class var1);

    public void setObjectField(Class c, String n, Object o, Object v) {
        String sig = DeserializationKernelNative.getCachedSignature(c, n);
        DeserializationKernelNative.nativeSetObjectField(c, n, o, v, sig);
    }

    private static native void nativeSetObjectField(Class var0, String var1, Object var2, Object var3, String var4);

    public final void setBooleanField(Class c, String n, Object o, boolean v) {
        DeserializationKernelNative.nativeSetBooleanField(c, n, o, v, "Z");
    }

    private static native void nativeSetBooleanField(Class var0, String var1, Object var2, boolean var3, String var4);

    public final void setByteField(Class c, String n, Object o, byte v) {
        DeserializationKernelNative.nativeSetByteField(c, n, o, v, "B");
    }

    private static native void nativeSetByteField(Class var0, String var1, Object var2, byte var3, String var4);

    public void setCharField(Class c, String n, Object o, char v) {
        DeserializationKernelNative.nativeSetCharField(c, n, o, v, "C");
    }

    private static native void nativeSetCharField(Class var0, String var1, Object var2, char var3, String var4);

    public void setShortField(Class c, String n, Object o, short v) {
        DeserializationKernelNative.nativeSetShortField(c, n, o, v, "S");
    }

    private static native void nativeSetShortField(Class var0, String var1, Object var2, short var3, String var4);

    public void setIntField(Class c, String n, Object o, int v) {
        DeserializationKernelNative.nativeSetIntField(c, n, o, v, "I");
    }

    private static native void nativeSetIntField(Class var0, String var1, Object var2, int var3, String var4);

    public void setLongField(Class c, String n, Object o, long v) {
        DeserializationKernelNative.nativeSetLongField(c, n, o, v, "J");
    }

    private static native void nativeSetLongField(Class var0, String var1, Object var2, long var3, String var5);

    public void setFloatField(Class c, String n, Object o, float v) {
        DeserializationKernelNative.nativeSetFloatField(c, n, o, v, "F");
    }

    private static native void nativeSetFloatField(Class var0, String var1, Object var2, float var3, String var4);

    public void setDoubleField(Class c, String n, Object o, double v) {
        DeserializationKernelNative.nativeSetDoubleField(c, n, o, v, "D");
    }

    private static native void nativeSetDoubleField(Class var0, String var1, Object var2, double var3, String var5);
}

