/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.rmi.RMIRemoteStreamClass;
import org.openorb.orb.rmi._Remote_Stub;
import org.openorb.util.RepoIDHelper;

public class PortableRemoteObjectDelegateImpl
implements PortableRemoteObjectDelegate {
    static /* synthetic */ Class class$java$rmi$Remote;

    public void exportObject(Remote obj) throws RemoteException {
        if (obj != null) {
            if (obj instanceof Stub) {
                throw new ExportException("Attempted to export a stub class");
            }
            Tie tie = Util.getTie((Remote)obj);
            if (tie != null) {
                throw new ExportException("Object already exported");
            }
            tie = PortableRemoteObjectDelegateImpl.loadTie(obj);
            tie.orb(DefaultORB.getORB());
            Util.registerTarget((Tie)tie, (Remote)obj);
        }
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof Stub) {
            return obj;
        }
        Tie tie = null;
        if (obj instanceof Tie) {
            tie = (Tie)obj;
            obj = tie.getTarget();
        } else {
            tie = Util.getTie((Remote)obj);
        }
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Object thisObject = tie.thisObject();
        if (thisObject instanceof Remote) {
            return (Remote)thisObject;
        }
        Delegate deleg = ((org.omg.CORBA.portable.ObjectImpl)thisObject)._get_delegate();
        RMIRemoteStreamClass rsc = RMIRemoteStreamClass.lookup(obj.getClass());
        int total = rsc.countStubs();
        Stub stub = null;
        int i = 0;
        while (i < total) {
            try {
                stub = rsc.createStub(i);
                break;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (IncompatibleClassChangeError ex) {
                // empty catch block
            }
            ++i;
        }
        if (stub == null) {
            stub = new _Remote_Stub();
        }
        stub._set_delegate(deleg);
        return (Remote)stub;
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)obj);
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Util.unexportObject((Remote)obj);
    }

    public java.lang.Object narrow(java.lang.Object obj, Class newClass) throws ClassCastException {
        return PortableRemoteObjectDelegateImpl.narrowExt(obj, newClass, true);
    }

    public java.lang.Object uncheckedNarrow(java.lang.Object obj, Class newClass) throws ClassCastException {
        return PortableRemoteObjectDelegateImpl.narrowExt(obj, newClass, false);
    }

    static java.lang.Object narrowExt(java.lang.Object obj, Class newClass, boolean check) throws ClassCastException {
        Stub stub;
        Delegate deleg;
        if (obj == null) {
            return null;
        }
        Class<?> objClass = obj.getClass();
        if (newClass.isAssignableFrom(objClass)) {
            return obj;
        }
        if (!newClass.isInterface() || !(obj instanceof org.omg.CORBA.portable.ObjectImpl)) {
            throw new ClassCastException("Class of " + obj + " is ( " + obj.getClass().getName() + " ), i.e. is neither an interface nor an instance of" + " 'org.omg.CORBA.portable.ObjectImpl'");
        }
        org.omg.CORBA.portable.ObjectImpl oimpl = (org.omg.CORBA.portable.ObjectImpl)obj;
        Logger logger = null;
        ORB orb = oimpl._orb();
        if (orb instanceof ORBSingleton && (logger = ((ORBSingleton)orb).getLogger()) != null && logger.isErrorEnabled()) {
            logger = logger.getChildLogger("rmi");
        }
        try {
            deleg = oimpl._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Can't narrow unconnected target.", (Throwable)ex);
            }
            throw new IllegalArgumentException("Can't narrow unconnected target (" + (java.lang.Object)((java.lang.Object)ex) + ")");
        }
        String codebase = null;
        if (oimpl instanceof ObjectImpl) {
            codebase = ((ObjectImpl)oimpl)._get_codebase();
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = PortableRemoteObjectDelegateImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(newClass)) {
            RMIRemoteStreamClass rsc = RMIRemoteStreamClass.lookup(newClass);
            String[] ids = rsc.getRepoIDs();
            if (check && !oimpl._is_a(ids[0])) {
                throw new ClassCastException("The _is_a('" + ids[0] + "') on the following" + " object failed: " + oimpl);
            }
            try {
                stub = rsc.createStub(0);
            }
            catch (ClassNotFoundException ex) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error("Stub creation failed.", (Throwable)ex);
                }
                throw new ClassCastException("Stub creation failed (" + ex + ")");
            }
        }
        String[] str = RepoIDHelper.extractClassName((Class)newClass);
        String stubName = (str[0].length() == 0 ? "_" : str[0] + "._") + str[1] + "_Stub";
        try {
            Class helper = Util.loadClass((String)stubName, (String)codebase, (ClassLoader)newClass.getClassLoader());
            stub = (org.omg.CORBA.portable.ObjectImpl)helper.newInstance();
        }
        catch (ClassNotFoundException ex) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Helper class " + stubName + " not found.", (Throwable)ex);
            }
            throw new ClassCastException("Helper class " + stubName + " not found (" + ex + ")");
        }
        catch (InstantiationException ex) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Instantiation of class " + stubName + " failed.", (Throwable)ex);
            }
            throw new ClassCastException("Instantiation of class " + stubName + " failed (" + ex + ")");
        }
        catch (IllegalAccessException ex) {
            if (logger != null && logger.isErrorEnabled()) {
                logger.error("Illegal access while creating class " + stubName + ".", (Throwable)ex);
            }
            throw new ClassCastException("Illegal access while creating class " + stubName + " (" + ex + ")");
        }
        String[] ids = stub._ids();
        if (check && !oimpl._is_a(ids[0])) {
            throw new ClassCastException("The _is_a('" + ids[0] + "') on the following" + " object failed: " + oimpl);
        }
        stub._set_delegate(deleg);
        return stub;
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        Tie tie;
        ORB orb = null;
        if (source instanceof org.omg.CORBA.portable.ObjectImpl) {
            try {
                orb = ((org.omg.CORBA.portable.ObjectImpl)source)._orb();
            }
            catch (BAD_OPERATION ex) {}
        } else {
            tie = Util.getTie((Remote)source);
            if (tie != null) {
                orb = tie.orb();
            }
        }
        if (orb == null) {
            throw new RemoteException("Source object not exported");
        }
        if (target instanceof Stub) {
            ((Stub)target).connect(orb);
        } else {
            tie = Util.getTie((Remote)target);
            if (tie != null) {
                throw new ExportException("Object already exported");
            }
            tie = PortableRemoteObjectDelegateImpl.loadTie(target);
            tie.orb(orb);
            Util.registerTarget((Tie)tie, (Remote)target);
        }
    }

    static Tie loadTie(Remote obj) throws ExportException {
        RMIRemoteStreamClass rsc = RMIRemoteStreamClass.lookup(obj.getClass());
        if (rsc == null) {
            throw new ExportException("Target object is not compatable with RMI/IIOP");
        }
        return rsc.createTie();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

