/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UNKNOWNHelper;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.orb.Initializer;
import org.openorb.orb.core.LoggableLocalObject;
import org.openorb.orb.net.ClientRequest;
import org.openorb.orb.net.ServerRequest;
import org.openorb.orb.pi.FeatureInitInfo;
import org.openorb.orb.pi.FeatureInitializer;
import org.openorb.orb.util.Trace;

public class RMIInitializer
extends LoggableLocalObject
implements FeatureInitializer,
ORBInitializer,
Initializer {
    private ORB m_orb;

    public String getName() {
        return "rmi";
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec;
        try {
            codec = info.codec_factory().create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding ex) {
            return;
        }
        try {
            ClientInterceptor clt = new ClientInterceptor(codec, this.m_orb);
            clt.enableLogging(this.getLogger());
            info.add_client_request_interceptor((ClientRequestInterceptor)clt);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(clt.name() + " installed.");
            }
        }
        catch (DuplicateName ex) {
            // empty catch block
        }
        try {
            ServerInterceptor srv = new ServerInterceptor(codec, this.m_orb);
            srv.enableLogging(this.getLogger());
            info.add_server_request_interceptor((ServerRequestInterceptor)srv);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(srv.name() + " installed.");
            }
        }
        catch (DuplicateName duplicateName) {
            // empty catch block
        }
    }

    public void init(ORBInitInfo orbinfo, FeatureInitInfo featureinfo) {
        this.enableLogging(this.getLogger().getChildLogger("rmi"));
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("init");
        }
        this.m_orb = featureinfo.orb();
    }

    private static class ServerInterceptor
    extends LoggableLocalObject
    implements ServerRequestInterceptor {
        private Codec m_codec;
        private ORB m_orb;

        ServerInterceptor(Codec codec, ORB orb) {
            this.m_codec = codec;
            this.m_orb = orb;
        }

        public String name() {
            return "ServerInterceptor";
        }

        public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
            byte[] encode;
            if (ri.reply_status() != 1 || !(ri instanceof ServerRequest)) {
                return;
            }
            SystemException sys = ((ServerRequest)ri).sending_system_exception();
            if (!(sys instanceof UnknownException)) {
                return;
            }
            UnknownException uex = (UnknownException)sys;
            Any any = this.m_orb.create_any();
            any.insert_Value((Serializable)uex.originalEx);
            try {
                encode = this.m_codec.encode_value(any);
            }
            catch (InvalidTypeForEncoding ex) {
                return;
            }
            ServiceContext sc = new ServiceContext(9, encode);
            ri.add_reply_service_context(sc, true);
        }

        public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void send_reply(ServerRequestInfo ri) {
        }

        public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        }

        public void destroy() {
        }
    }

    private static class ClientInterceptor
    extends LoggableLocalObject
    implements ClientRequestInterceptor {
        private Codec m_codec;
        private ORB m_orb;

        ClientInterceptor(Codec codec, ORB orb) {
            this.m_codec = codec;
            this.m_orb = orb;
        }

        public String name() {
            return "ClientInterceptor";
        }

        public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
            Throwable cex;
            Any cex_any;
            ServiceContext sc;
            if (ri.reply_status() != 1 || !ri.received_exception_id().equals(UNKNOWNHelper.id())) {
                return;
            }
            try {
                sc = ri.get_reply_service_context(9);
            }
            catch (BAD_PARAM ex) {
                return;
            }
            SystemException sys = ri instanceof ClientRequest ? ((ClientRequest)ri).received_system_exception() : UNKNOWNHelper.extract((Any)ri.received_exception());
            try {
                cex_any = this.m_codec.decode_value(sc.context_data, this.m_orb.get_primitive_tc(TCKind.tk_value));
            }
            catch (FormatMismatch ex) {
                return;
            }
            catch (TypeMismatch ex) {
                return;
            }
            try {
                cex = (Throwable)cex_any.extract_Value();
            }
            catch (SystemException ex) {
                return;
            }
            catch (ClassCastException ex) {
                return;
            }
            UnknownException uex = new UnknownException(cex);
            uex.minor = sys.minor;
            uex.completed = sys.completed;
            throw uex;
        }

        public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        }

        public void send_poll(ClientRequestInfo ri) {
        }

        public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        }

        public void receive_reply(ClientRequestInfo ri) {
        }

        public void destroy() {
        }
    }
}

