/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.Serializable;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.openorb.orb.rmi.RMIObjectStreamClass;
import org.openorb.orb.rmi.UtilDelegateImpl;
import org.openorb.orb.rmi.ValueHandlerImpl;

class RMIObjectInputStream
extends ObjectInputStream {
    private static WStringValueHelper s_string_helper = new WStringValueHelper();
    private ValueHandlerImpl m_handler;
    private InputStream m_is;
    private Serializable m_value;
    private RMIObjectStreamClass m_value_data;

    void setContext(Serializable value, RMIObjectStreamClass valueData) {
        this.m_value = value;
        this.m_value_data = valueData;
    }

    RMIObjectInputStream(ValueHandlerImpl handler, InputStream is) throws IOException {
        this.m_handler = handler;
        this.m_is = is;
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        try {
            return this.m_is.available();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int skipBytes(int param) throws IOException {
        try {
            return (int)this.m_is.skip(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public long skip(long param) throws IOException {
        try {
            return (int)this.m_is.skip(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int read() throws IOException {
        try {
            return this.m_is.read();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int read(byte[] values) throws IOException {
        try {
            return this.m_is.read(values);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int read(byte[] values, int param, int param2) throws IOException {
        try {
            return this.m_is.read(values, param, param2);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public boolean readBoolean() throws IOException {
        try {
            return this.m_is.read_boolean();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int readUnsignedByte() throws IOException {
        try {
            return this.m_is.read_octet() & 0xFF;
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.m_is.read_octet();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            return this.m_is.read_ushort() & 0xFFFF;
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public short readShort() throws IOException {
        try {
            return this.m_is.read_short();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public int readInt() throws IOException {
        try {
            return this.m_is.read_long();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public long readLong() throws IOException {
        try {
            return this.m_is.read_longlong();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.m_is.read_double();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.m_is.read_float();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public char readChar() throws IOException {
        try {
            return this.m_is.read_wchar();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public String readUTF() throws IOException {
        try {
            Serializable val = this.m_is.read_value((BoxedValueHelper)s_string_helper);
            if (val == null || val instanceof String) {
                return (String)((Object)val);
            }
            throw new InvalidObjectException("Value read was not a string");
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String readLine() throws IOException {
        char c;
        StringBuffer ret = new StringBuffer();
        int r = this.read();
        while (r >= 0 && (c = (char)r) != '\n') {
            void var3_3;
            if (var3_3 != 13) {
                ret.append((char)var3_3);
            }
            r = this.read();
        }
        return ret.toString();
    }

    public void readFully(byte[] values) throws IOException {
        try {
            this.m_is.read_octet_array(values, 0, values.length);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void readFully(byte[] values, int param, int param2) throws IOException {
        try {
            this.m_is.read_octet_array(values, param, param2);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        try {
            return this.m_is.read_abstract_interface();
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.m_value == null) {
            throw new NotActiveException();
        }
        try {
            this.m_handler.defaultReadObject(this.m_is, this.m_value, this.m_value_data);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.m_value == null) {
            throw new NotActiveException();
        }
        return this.m_handler.readFields(this.m_is, this.m_value, this.m_value_data);
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int param) throws NotActiveException, InvalidObjectException {
        throw new RuntimeException("The ObjectInputStream.registerValidation() has not been implemented yet!");
    }
}

