/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.orb.rmi.RMIObjectStreamClass;
import org.openorb.orb.rmi.UtilDelegateImpl;
import org.openorb.orb.rmi.ValueHandlerImpl;

class RMIObjectOutputStream
extends ObjectOutputStream {
    private static WStringValueHelper s_string_helper = new WStringValueHelper();
    private ValueHandlerImpl m_handler;
    private OutputStream m_out_stream;
    private Serializable m_value;
    private RMIObjectStreamClass m_value_stream_class;
    private ObjectOutputStream.PutField m_fields;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    RMIObjectOutputStream(ValueHandlerImpl handler, OutputStream os, Serializable value, RMIObjectStreamClass valueData) throws IOException {
        this.m_handler = handler;
        this.m_out_stream = os;
        this.m_value = value;
        this.m_value_stream_class = valueData;
    }

    RMIObjectOutputStream(ValueHandlerImpl handler, OutputStream os) throws IOException {
        this.m_handler = handler;
        this.m_out_stream = os;
    }

    void setContext(Serializable value, RMIObjectStreamClass valueData) {
        this.m_value = value;
        this.m_value_stream_class = valueData;
        this.m_fields = null;
    }

    public void useProtocolVersion(int param) throws IOException {
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public void write(int param) throws IOException {
        try {
            this.m_out_stream.write_octet((byte)param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void write(byte[] values) throws IOException {
        try {
            this.m_out_stream.write_octet_array(values, 0, values.length);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void write(byte[] values, int param, int param2) throws IOException {
        try {
            this.m_out_stream.write_octet_array(values, param, param2);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeBoolean(boolean param) throws IOException {
        try {
            this.m_out_stream.write_boolean(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeByte(int param) throws IOException {
        try {
            this.m_out_stream.write_octet((byte)param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeShort(int param) throws IOException {
        try {
            this.m_out_stream.write_short((short)param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeInt(int param) throws IOException {
        try {
            this.m_out_stream.write_long(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeLong(long param) throws IOException {
        try {
            this.m_out_stream.write_longlong(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeDouble(double param) throws IOException {
        try {
            this.m_out_stream.write_double(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeFloat(float param) throws IOException {
        try {
            this.m_out_stream.write_float(param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeBytes(String str) throws IOException {
        try {
            byte[] buf = str.getBytes();
            this.m_out_stream.write_octet_array(buf, 0, buf.length);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeChar(int param) throws IOException {
        try {
            this.m_out_stream.write_wchar((char)param);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeChars(String str) throws IOException {
        char[] dst = new char[str.length()];
        str.getChars(0, dst.length, dst, 0);
        try {
            this.m_out_stream.write_wchar_array(dst, 0, dst.length);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void writeUTF(String str) throws IOException {
        try {
            this.m_out_stream.write_value((Serializable)((Object)str), (BoxedValueHelper)s_string_helper);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        Class<?> clz;
        if (obj != null && !(class$java$io$Serializable == null ? (class$java$io$Serializable = RMIObjectOutputStream.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz = obj.getClass()) && !(class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = RMIObjectOutputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clz)) {
            throw new NotSerializableException(clz.getName());
        }
        try {
            this.m_out_stream.write_abstract_interface(obj);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public void defaultWriteObject() throws IOException {
        if (this.m_value == null) {
            throw new NotActiveException();
        }
        try {
            this.m_handler.defaultWriteObject(this.m_out_stream, this.m_value, this.m_value_stream_class);
        }
        catch (SystemException ex) {
            throw UtilDelegateImpl.mapSysIOException(ex);
        }
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.m_value == null) {
            throw new NotActiveException();
        }
        this.m_fields = this.m_handler.putFields(this.m_value, this.m_value_stream_class);
        return this.m_fields;
    }

    public void writeFields() throws IOException {
        if (this.m_value == null || this.m_fields == null) {
            throw new NotActiveException();
        }
        this.m_handler.writeFields(this.m_out_stream, this.m_value, this.m_fields);
        this.m_fields = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

