/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.io.ExtendedInputStream;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.rmi.RMIRemoteStreamClass;
import org.openorb.orb.rmi.UtilDelegateImpl;
import org.openorb.util.ReflectionUtils;
import org.openorb.util.RepoIDHelper;

public final class RMIObjectStreamClass {
    private static final ThreadLocal STREAM_CLASSES = new ThreadLocal();
    private static final Map GLOBAL_CLASSES = new HashMap();
    private static ORBSingleton s_orb = new ORBSingleton();
    private static RMIObjectStreamClass s_strosc = new RMIObjectStreamClass(class$java$lang$String == null ? (class$java$lang$String = RMIObjectStreamClass.class$("java.lang.String")) : class$java$lang$String, "IDL:omg.org/CORBA/WStringValue:1.0", 0L);
    private static RMIObjectStreamClass s_anyosc = new RMIObjectStreamClass(class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any, "RMI:org.omg.CORBA.Any:0000000000000000", 0L);
    private static RMIObjectStreamClass s_tcosc = new RMIObjectStreamClass(class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode, "RMI:org.omg.CORBA.TypeCode:0000000000000000", 0L);
    private static RMIObjectStreamClass s_cdosc = new RMIObjectStreamClass(class$java$lang$Class == null ? (class$java$lang$Class = RMIObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class, "RMI:javax.rmi.CORBA.ClassDesc:2BABDA04587ADCCC:CFBF02CF5294176B", 3146848476847594700L);
    private ObjectStreamClass m_delegate;
    private long m_repo_id_hash;
    private String m_repository_id;
    private boolean m_idl_entity = false;
    private boolean m_externalizable = false;
    private boolean m_custom_marshaled = false;
    private RMIObjectStreamClass[] m_all_classes = null;
    private Class m_class_base;
    private Method m_read_object_method;
    private Method m_write_object_method;
    private Method m_read_resolve_method;
    private Method m_write_replace_method;
    private TypeCode m_type;
    private Field[] m_fields;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$TypeCode;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$openorb$orb$rmi$RMIObjectStreamClass;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueBase;
    static /* synthetic */ Class class$java$rmi$Remote;

    private RMIObjectStreamClass(Class clz, String repoID, long repoIDHash) {
        RMIObjectStreamClass.addToLocalCache(clz, this);
        this.m_delegate = ObjectStreamClass.lookup(clz);
        this.m_repository_id = repoID.intern();
        this.m_repo_id_hash = repoIDHash;
        this.m_idl_entity = RMIObjectStreamClass.isIDLEntity(clz);
        RMIObjectStreamClass.addToGlobalCache(clz, this);
    }

    private static boolean isIDLEntity(Class clz) {
        boolean result = false;
        if (clz != null) {
            result = (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = RMIObjectStreamClass.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz);
        }
        return result;
    }

    private static boolean isCustomMarshaled(Class clz) {
        boolean result = false;
        if (clz != null && !(class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = RMIObjectStreamClass.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz)) {
            if ((class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any).isAssignableFrom(clz)) {
                clz = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
            } else if ((class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode).isAssignableFrom(clz)) {
                clz = class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = RMIObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
                result = true;
            } else if (!clz.isArray() && !(result = ReflectionUtils.hasWriteObjectMethod((Class)clz))) {
                result = RMIObjectStreamClass.isCustomMarshaled(clz.getSuperclass());
            }
        }
        return result;
    }

    private static TypeCode getTypeCodeFromHelper(Class helper) throws InvalidClassException {
        TypeCode result = null;
        try {
            result = (TypeCode)helper.getMethod("type", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable real = ex.getTargetException();
            if (real instanceof RuntimeException) {
                throw (RuntimeException)real;
            }
            if (real instanceof Error) {
                throw (Error)real;
            }
            throw new InvalidClassException(helper.getName(), "Exception while invoking type method (" + real + ")");
        }
        catch (IllegalAccessException ex) {
            throw new InvalidClassException(helper.getName(), "Exception while invoking type method (" + ex + ")");
        }
        catch (NoSuchMethodException ex) {
            throw new InvalidClassException(helper.getName(), "Exception while invoking type method (" + ex + ")");
        }
        return result;
    }

    private RMIObjectStreamClass(Class clz, boolean suppressPackageCheck) throws InvalidClassException {
        Class lookupClz = clz;
        RMIObjectStreamClass.addToLocalCache(lookupClz, this);
        if ((class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any).isAssignableFrom(clz)) {
            clz = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
        } else if ((class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode).isAssignableFrom(clz)) {
            clz = class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode;
        }
        this.m_repository_id = RepoIDHelper.getRepoID((Class)clz);
        this.m_repo_id_hash = RepoIDHelper.getRepoIDHash((Class)clz);
        this.m_delegate = ObjectStreamClass.lookup(clz);
        if (clz.isArray()) {
            String[] names = RepoIDHelper.mangleClassName((Class)clz);
            Class<?> cmpt = clz.getComponentType();
            TypeCode contained = RMIObjectStreamClass.lookupTypeCode(cmpt);
            this.m_type = s_orb.create_value_box_tc(this.getRepoID(), names[1], s_orb.create_sequence_tc(0, contained));
            RMIObjectStreamClass.addToGlobalCache(lookupClz, this);
            return;
        }
        this.m_custom_marshaled = RMIObjectStreamClass.isCustomMarshaled(clz);
        TypeCode baseType = null;
        ObjectStreamField[] fields = this.m_delegate.getFields();
        boolean[] isPublic = new boolean[fields.length];
        int totalPublic = 0;
        RMIObjectStreamClass parent = null;
        this.m_fields = new Field[fields.length];
        int i = 0;
        while (i < this.m_fields.length) {
            ObjectStreamField currentField = fields[i];
            try {
                this.m_fields[i] = clz.getDeclaredField(currentField.getName());
                ((AccessibleObject)this.m_fields[i]).setAccessible(true);
                if (Modifier.isPublic(this.m_fields[i].getModifiers())) {
                    isPublic[i] = true;
                    ++totalPublic;
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            ++i;
        }
        this.m_idl_entity = RMIObjectStreamClass.isIDLEntity(clz);
        if (this.isIDLEntity()) {
            if ((class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any).isAssignableFrom(clz)) {
                this.m_type = RMIObjectStreamClass.s_anyosc.m_type;
                this.m_read_object_method = RMIObjectStreamClass.s_anyosc.m_read_object_method;
                this.m_write_object_method = RMIObjectStreamClass.s_anyosc.m_write_object_method;
            } else if ((class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode).isAssignableFrom(clz)) {
                this.m_type = RMIObjectStreamClass.s_tcosc.m_type;
                this.m_read_object_method = RMIObjectStreamClass.s_tcosc.m_read_object_method;
                this.m_write_object_method = RMIObjectStreamClass.s_tcosc.m_write_object_method;
            } else {
                Class helper = UtilDelegateImpl.locateHelperClass(clz);
                if (helper == null) {
                    throw new InvalidClassException("Unable to find class '" + clz.getName() + "Helper'", "ClassNotFoundException");
                }
                String[] names = RepoIDHelper.mangleClassName((Class)clz);
                this.m_type = s_orb.create_value_box_tc(this.getRepoID(), names[1], RMIObjectStreamClass.getTypeCodeFromHelper(helper));
                try {
                    this.m_read_object_method = helper.getMethod("read", class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream);
                    this.m_write_object_method = helper.getMethod("write", class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clz);
                }
                catch (NoSuchMethodException ex) {
                    throw new InvalidClassException(helper.getName(), "Couldn't find read/write method (" + ex + ")");
                }
            }
        } else {
            short type_modifier;
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = RMIObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
                Class base = clz.getSuperclass();
                while ((class$java$io$Serializable == null ? RMIObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(base) && parent == null) {
                    try {
                        parent = RMIObjectStreamClass.lookup(base);
                    }
                    catch (InvalidClassException ex) {
                        try {
                            parent = new RMIObjectStreamClass(base, true);
                        }
                        catch (InvalidClassException ex1) {
                            base = base.getSuperclass();
                        }
                    }
                }
                if (parent != null) {
                    baseType = parent.m_type;
                }
                if (!suppressPackageCheck) {
                    try {
                        clz.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new InvalidClassException(base.getName() + "Missing no-arg constructor for class (" + ex + ")");
                    }
                }
                this.m_externalizable = true;
                this.m_class_base = clz;
                this.m_fields = null;
            } else {
                this.m_class_base = clz.getSuperclass();
                if (this.m_class_base != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = RMIObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.m_class_base)) {
                    try {
                        parent = RMIObjectStreamClass.lookup(this.m_class_base);
                    }
                    catch (InvalidClassException ex) {
                        parent = new RMIObjectStreamClass(this.m_class_base, true);
                    }
                }
                if (parent != null) {
                    baseType = parent.m_type;
                    this.m_class_base = parent.m_class_base;
                    this.m_all_classes = new RMIObjectStreamClass[parent.m_all_classes.length + 1];
                    System.arraycopy(parent.m_all_classes, 0, this.m_all_classes, 0, parent.m_all_classes.length);
                    this.m_all_classes[parent.m_all_classes.length] = this;
                } else {
                    this.m_all_classes = new RMIObjectStreamClass[]{this};
                }
                if (this.m_class_base != null && !this.m_class_base.equals(class$java$lang$Object == null ? (class$java$lang$Object = RMIObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object)) {
                    Constructor ctor;
                    try {
                        ctor = this.m_class_base.getDeclaredConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new InvalidClassException(this.m_class_base.getName() + "Missing no-arg constructor for class (" + ex + ")");
                    }
                    int modf = ctor.getModifiers();
                    if (Modifier.isPrivate(modf) || !suppressPackageCheck && !Modifier.isPublic(modf) && !Modifier.isProtected(modf) && !this.m_class_base.getPackage().equals(clz.getPackage())) {
                        throw new InvalidClassException(this.m_class_base.getName(), "IllegalAccessException");
                    }
                }
                if (!clz.isArray()) {
                    this.m_read_object_method = ReflectionUtils.getReadObjectMethod((Class)clz);
                    this.m_write_object_method = ReflectionUtils.getWriteObjectMethod((Class)clz);
                    this.m_write_replace_method = ReflectionUtils.getWriteReplaceMethod((Class)clz);
                    this.m_read_resolve_method = ReflectionUtils.getReadResolveMethod((Class)clz);
                }
            }
            short s = type_modifier = this.isCustomMarshaled() ? (short)1 : 0;
            if (baseType == null) {
                baseType = s_orb.get_primitive_tc(TCKind.tk_null);
            }
            ValueMember[] tcMembers = new ValueMember[this.m_externalizable ? totalPublic : fields.length];
            if (fields.length > 0) {
                String[] memberNames = new String[tcMembers.length];
                int upto = 0;
                int i2 = 0;
                while (i2 < fields.length) {
                    if (!this.m_externalizable || isPublic[i2]) {
                        tcMembers[upto] = new ValueMember();
                        memberNames[upto] = fields[i2].getName();
                        Class<?> fType = fields[i2].getType();
                        RMIObjectStreamClass sc = RMIObjectStreamClass.getFromCache(fType);
                        tcMembers[upto].type = sc != null ? (sc.type() == null ? s_orb.create_recursive_tc(sc.getRepoID()) : sc.type()) : RMIObjectStreamClass.lookupTypeCode(fType);
                        tcMembers[upto].access = isPublic[i2] ? (short)1 : 0;
                        ++upto;
                    }
                    ++i2;
                }
                RepoIDHelper.mangleMemberNames((Class)clz, (String[])memberNames);
                int i3 = 0;
                while (i3 < memberNames.length) {
                    tcMembers[i3].name = memberNames[i3];
                    ++i3;
                }
            }
            try {
                this.m_type = s_orb.create_value_tc(this.getRepoID(), "", type_modifier, baseType, tcMembers);
            }
            catch (BAD_PARAM ex) {
                throw new InvalidClassException(clz.getName(), "Duplicate member name (" + (Object)((Object)ex) + ")");
            }
        }
        RMIObjectStreamClass.addToGlobalCache(lookupClz, this);
    }

    public static RMIObjectStreamClass lookup(Class clz) throws InvalidClassException {
        RMIObjectStreamClass ret = RMIObjectStreamClass.getFromCache(clz);
        if (ret == null) {
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = RMIObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz) || (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = RMIObjectStreamClass.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clz) || (class$org$omg$CORBA$portable$ValueBase == null ? (class$org$omg$CORBA$portable$ValueBase = RMIObjectStreamClass.class$("org.omg.CORBA.portable.ValueBase")) : class$org$omg$CORBA$portable$ValueBase).isAssignableFrom(clz) || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIObjectStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz)) {
                return null;
            }
            ret = new RMIObjectStreamClass(clz, false);
        }
        return ret;
    }

    public static TypeCode lookupTypeCode(Class clz) throws InvalidClassException {
        RMIObjectStreamClass osc;
        if (clz.isPrimitive()) {
            if (clz.equals(Boolean.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_boolean);
            }
            if (clz.equals(Byte.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_octet);
            }
            if (clz.equals(Short.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_short);
            }
            if (clz.equals(Integer.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_long);
            }
            if (clz.equals(Long.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_longlong);
            }
            if (clz.equals(Float.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_float);
            }
            if (clz.equals(Double.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_double);
            }
            if (clz.equals(Character.TYPE)) {
                return s_orb.get_primitive_tc(TCKind.tk_wchar);
            }
            throw new InternalError("Unknown primitive type");
        }
        if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = RMIObjectStreamClass.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).equals(clz)) {
            return s_orb.get_primitive_tc(TCKind.tk_objref);
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = RMIObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object).equals(clz)) {
            return s_orb.get_primitive_tc(TCKind.tk_abstract_interface);
        }
        if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIObjectStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz)) {
            RMIRemoteStreamClass rsc = RMIRemoteStreamClass.lookup(clz);
            if (rsc == null) {
                return null;
            }
            return rsc.getInterfaceTypesNoCopy()[0];
        }
        if ((class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = RMIObjectStreamClass.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz)) {
            if (clz.equals(class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any)) {
                return s_anyosc.type();
            }
            if (clz.equals(class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode)) {
                return s_tcosc.type();
            }
            Class helper = UtilDelegateImpl.locateHelperClass(clz);
            if (helper == null) {
                throw new InvalidClassException("Unable to find class '" + clz.getName() + "Helper'", "ClassNotFoundException");
            }
            return RMIObjectStreamClass.getTypeCodeFromHelper(helper);
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = RMIObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz) && (osc = RMIObjectStreamClass.lookup(clz)) != null) {
            return osc.type();
        }
        String clzName = clz.getName();
        Package pkg = clz.getPackage();
        String npkg = clzName;
        if (pkg != null && pkg.getName().length() > 0) {
            npkg = clzName.substring(pkg.getName().length() + 1);
        }
        return s_orb.create_abstract_interface_tc("RMI:" + clzName + ":0000000000000000", npkg);
    }

    public long getRepoIDHash() {
        return this.m_repo_id_hash;
    }

    public String getRepoID() {
        return this.m_repository_id;
    }

    public Class getBaseClass() {
        return this.m_class_base;
    }

    public boolean isCustomMarshaled() {
        return this.m_custom_marshaled;
    }

    public boolean isExternalizable() {
        return this.m_externalizable;
    }

    public boolean hasWriteObject() {
        return !this.m_idl_entity && this.m_write_object_method != null;
    }

    public boolean hasReadObject() {
        return !this.m_idl_entity && this.m_read_object_method != null;
    }

    public boolean isIDLEntity() {
        return this.m_idl_entity;
    }

    public RMIObjectStreamClass[] getAllStreamClasses() {
        return this.m_all_classes;
    }

    public Class forClass() {
        return this.m_delegate.forClass();
    }

    public String getName() {
        return this.m_delegate.getName();
    }

    public long getSerialVersionUID() {
        return this.m_delegate.getSerialVersionUID();
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    public TypeCode type() {
        return this.m_type;
    }

    public ObjectStreamClass getObjectStreamClass() {
        return this.m_delegate;
    }

    public ObjectStreamField[] getObjectStreamFields() {
        return this.m_delegate.getFields();
    }

    Field[] getSerializedFields() {
        return this.m_fields;
    }

    boolean readObject(Object target, ObjectInputStream is) throws IOException, ClassNotFoundException {
        return ReflectionUtils.readObject((Method)this.m_read_object_method, (Object)target, (ObjectInputStream)is);
    }

    void writeObject(Object target, ObjectOutputStream os) throws IOException {
        ReflectionUtils.writeObject((Method)this.m_write_object_method, (Object)target, (ObjectOutputStream)os);
    }

    Object readResolve(Object target) throws ObjectStreamException {
        return ReflectionUtils.readResolve((Method)this.m_read_resolve_method, (Object)target);
    }

    Object writeReplace(Object target) throws ObjectStreamException {
        return ReflectionUtils.writeReplace((Method)this.m_write_replace_method, (Object)target);
    }

    Object read(InputStream is) {
        if (!this.isIDLEntity()) {
            throw new IllegalStateException("IDLEntity");
        }
        try {
            return this.m_read_object_method.invoke(null, is);
        }
        catch (InvocationTargetException ex) {
            Throwable nex = ex.getTargetException();
            if (nex instanceof RuntimeException) {
                throw (RuntimeException)nex;
            }
            if (nex instanceof Error) {
                throw (Error)nex;
            }
            throw new Error("Unexpected exception (" + ex.getTargetException() + ")");
        }
        catch (Exception ex) {
            throw new Error("Unexpected exception (" + ex + ")");
        }
    }

    Object write(OutputStream os, Object value) {
        if (!this.isIDLEntity()) {
            throw new IllegalStateException("IDLEntity");
        }
        try {
            return this.m_write_object_method.invoke(null, os, value);
        }
        catch (InvocationTargetException ex) {
            Throwable nex = ex.getTargetException();
            if (nex instanceof RuntimeException) {
                throw (RuntimeException)nex;
            }
            if (nex instanceof Error) {
                throw (Error)nex;
            }
            throw new Error("Unexpected exception (" + ex.getTargetException() + ")");
        }
        catch (Exception ex) {
            throw new Error("Unexpected exception (" + ex + ")");
        }
    }

    private static Any readAny(InputStream is) {
        ORB orb = null;
        orb = is instanceof ExtendedInputStream ? ((ExtendedInputStream)is).orb() : DefaultORB.getORB();
        Any any = orb.create_any();
        any.read_value(is, is.read_TypeCode());
        return any;
    }

    private static void writeAny(OutputStream os, Any any) {
        os.write_TypeCode(any.type());
        any.write_value(os);
    }

    private static TypeCode readTypeCode(InputStream is) {
        return is.read_TypeCode();
    }

    private static void writeTypeCode(OutputStream os, TypeCode tc) {
        os.write_TypeCode(tc);
    }

    private static Map getStreamClassesMap() {
        HashMap<Class, RMIObjectStreamClass> map = (HashMap<Class, RMIObjectStreamClass>)STREAM_CLASSES.get();
        if (map == null) {
            map = new HashMap<Class, RMIObjectStreamClass>();
            map.put(class$java$lang$String == null ? (class$java$lang$String = RMIObjectStreamClass.class$("java.lang.String")) : class$java$lang$String, s_strosc);
            map.put(class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any, s_anyosc);
            map.put(class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode, s_tcosc);
            map.put(class$java$lang$Class == null ? (class$java$lang$Class = RMIObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class, s_cdosc);
            STREAM_CLASSES.set(map);
        }
        return map;
    }

    private static void addToLocalCache(Class clz, RMIObjectStreamClass strclz) {
        Map map = RMIObjectStreamClass.getStreamClassesMap();
        map.put(clz, strclz);
    }

    private static void addToGlobalCache(Class clz, RMIObjectStreamClass strclz) {
        Map map = GLOBAL_CLASSES;
        synchronized (map) {
            if (GLOBAL_CLASSES.get(clz) == null) {
                GLOBAL_CLASSES.put(clz, strclz);
            }
        }
    }

    private static RMIObjectStreamClass getFromCache(Class clz) {
        Map map = RMIObjectStreamClass.getStreamClassesMap();
        RMIObjectStreamClass strclz = (RMIObjectStreamClass)map.get(clz);
        if (strclz == null) {
            Map map2 = GLOBAL_CLASSES;
            synchronized (map2) {
                strclz = (RMIObjectStreamClass)GLOBAL_CLASSES.get(clz);
            }
            if (strclz != null) {
                map.put(clz, strclz);
            }
        }
        return strclz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class t = class$org$openorb$orb$rmi$RMIObjectStreamClass == null ? (class$org$openorb$orb$rmi$RMIObjectStreamClass = RMIObjectStreamClass.class$("org.openorb.orb.rmi.RMIObjectStreamClass")) : class$org$openorb$orb$rmi$RMIObjectStreamClass;
            RMIObjectStreamClass.s_anyosc.m_read_object_method = t.getDeclaredMethod("readAny", class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream);
            RMIObjectStreamClass.s_anyosc.m_write_object_method = t.getDeclaredMethod("writeAny", class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = RMIObjectStreamClass.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any);
            RMIObjectStreamClass.s_tcosc.m_read_object_method = t.getDeclaredMethod("readTypeCode", class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream);
            RMIObjectStreamClass.s_tcosc.m_write_object_method = t.getDeclaredMethod("writeTypeCode", class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = RMIObjectStreamClass.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = RMIObjectStreamClass.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode);
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchMethodError("No method readAny/writeAny/readTypeCode/wrteTypeCode found (" + ex + ")");
        }
        RMIObjectStreamClass.s_strosc.m_type = s_orb.create_value_box_tc(s_strosc.getRepoID(), "WStringValue", s_orb.get_primitive_tc(TCKind.tk_wstring));
        RMIObjectStreamClass.s_anyosc.m_type = s_orb.create_value_box_tc(s_anyosc.getRepoID(), "Any", s_orb.get_primitive_tc(TCKind.tk_any));
        RMIObjectStreamClass.s_tcosc.m_type = s_orb.create_value_box_tc(s_tcosc.getRepoID(), "TypeCode", s_orb.get_primitive_tc(TCKind.tk_TypeCode));
        ValueMember[] members = new ValueMember[2];
        members[0] = new ValueMember();
        members[0].name = "codebase";
        members[0].type = RMIObjectStreamClass.s_strosc.m_type;
        members[0].access = 1;
        members[1] = new ValueMember();
        members[1].name = "repid";
        members[1].type = RMIObjectStreamClass.s_strosc.m_type;
        members[1].access = 1;
        RMIObjectStreamClass.s_cdosc.m_type = s_orb.create_value_tc(s_cdosc.getRepoID(), "ClassDesc", (short)0, s_orb.get_primitive_tc(TCKind.tk_null), members);
    }
}

