/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.util.RepoIDHelper;

public final class RMIRemoteStreamClass {
    private static final ThreadLocal STREAM_CLASSES = new ThreadLocal();
    private static final Map GLOBAL_CLASSES = new HashMap();
    private static final RMIRemoteStreamClass RC = new RMIRemoteStreamClass();
    private static ORBSingleton s_orb = new ORBSingleton();
    private Class m_implementation_class;
    private Class m_tie_class;
    private Class[] m_remote_interface_classes;
    private Class[] m_stub_classes;
    private String[] m_repository_ids;
    private TypeCode[] m_types;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$openorb$orb$rmi$_Remote_Stub;

    public static RMIRemoteStreamClass lookup(Class clz) {
        if (clz == null || !(class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz)) {
            return null;
        }
        RMIRemoteStreamClass rc = RMIRemoteStreamClass.getFromCache(clz);
        if (rc != null) {
            return rc;
        }
        Class[] derr = RMIRemoteStreamClass.getHelperClasses(clz);
        if (derr == null) {
            return null;
        }
        rc = RMIRemoteStreamClass.getFromCache(derr[0]);
        if (rc == null) {
            rc = new RMIRemoteStreamClass(derr);
            RMIRemoteStreamClass.addToCache(clz, rc);
        }
        return rc;
    }

    private RMIRemoteStreamClass() {
    }

    private RMIRemoteStreamClass(Class[] helperClz) {
        this.m_implementation_class = helperClz[0];
        if (!this.m_implementation_class.isInterface()) {
            this.m_remote_interface_classes = new Class[helperClz.length - 1];
            System.arraycopy(helperClz, 1, this.m_remote_interface_classes, 0, this.m_remote_interface_classes.length);
        } else {
            this.m_remote_interface_classes = new Class[]{this.m_implementation_class};
        }
        this.m_repository_ids = new String[this.m_remote_interface_classes.length];
        this.m_types = new TypeCode[this.m_remote_interface_classes.length];
        int i = 0;
        while (i < this.m_remote_interface_classes.length) {
            String[] names = RepoIDHelper.mangleClassName((Class)this.m_remote_interface_classes[i]);
            this.m_repository_ids[i] = "RMI:" + names[0] + ":0000000000000000";
            this.m_types[i] = s_orb.create_interface_tc(this.m_repository_ids[i], names[1]);
            ++i;
        }
    }

    public String[] getRepoIDs() {
        return (String[])this.m_repository_ids.clone();
    }

    String[] getRepoIDsNoCopy() {
        return this.m_repository_ids;
    }

    public TypeCode[] getInterfaceTypes() {
        return (TypeCode[])this.m_types.clone();
    }

    TypeCode[] getInterfaceTypesNoCopy() {
        return this.m_types;
    }

    synchronized Tie createTie() throws ExportException {
        if (this.m_tie_class == null) {
            String[] parts = RepoIDHelper.extractClassName((Class)this.m_implementation_class);
            String tieName = (parts[0].length() == 0 ? "_" : parts[0] + "._") + parts[1] + "_Tie";
            try {
                this.m_tie_class = Util.loadClass((String)tieName, (String)Util.getCodebase((Class)this.m_implementation_class), (ClassLoader)this.m_implementation_class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ExportException("Tie class not found (" + ex + ")", ex);
            }
        }
        try {
            return (Tie)this.m_tie_class.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ExportException("InstantiationException while creating tie (" + ex + ")", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExportException("IllegalAccessException while creating tie (" + ex + ")", ex);
        }
    }

    synchronized Stub createStub(int idx) throws ClassNotFoundException {
        if (this.m_stub_classes == null) {
            this.m_stub_classes = new Class[this.m_remote_interface_classes.length];
        }
        if (this.m_stub_classes[idx] == null) {
            String[] parts = RepoIDHelper.extractClassName((Class)this.m_remote_interface_classes[idx]);
            String stubName = (parts[0].length() == 0 ? "_" : parts[0] + "._") + parts[1] + "_Stub";
            this.m_stub_classes[idx] = Util.loadClass((String)stubName, (String)Util.getCodebase((Class)this.m_implementation_class), (ClassLoader)this.m_implementation_class.getClassLoader());
        }
        try {
            return (Stub)this.m_stub_classes[idx].newInstance();
        }
        catch (InstantiationException ex) {
            throw new IncompatibleClassChangeError("InstantiationException while creating stub (" + ex + ")");
        }
        catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("IllegalAccessException while creating stub (" + ex + ")");
        }
    }

    int countStubs() {
        return this.m_remote_interface_classes.length;
    }

    private static Class[] getHelperClasses(Class clz) {
        ArrayList tops = new ArrayList();
        Class tie = RMIRemoteStreamClass.getMostDerived(clz, new HashSet(), tops);
        if (tie == null) {
            return null;
        }
        if (tie.isInterface()) {
            return new Class[]{tie};
        }
        Class[] ret = new Class[tops.size() + 1];
        tops.toArray(ret);
        System.arraycopy(ret, 0, ret, 1, ret.length - 1);
        ret[0] = tie;
        return ret;
    }

    private static Class getMostDerived(Class clz, Set leaf, List tops) {
        Class sup;
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clz) || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).equals(clz)) {
            return null;
        }
        boolean isIfc = clz.isInterface();
        if (isIfc && leaf.contains(clz)) {
            return null;
        }
        Class<?>[] ifs = clz.getInterfaces();
        Class clazz = sup = isIfc ? null : clz.getSuperclass();
        if (!isIfc) {
            if (ifs.length == 0) {
                return RMIRemoteStreamClass.getMostDerived(clz.getSuperclass(), leaf, tops);
            }
            if (tops != null) {
                int i = 0;
                while (i < ifs.length) {
                    if (!(class$java$rmi$Remote == null ? RMIRemoteStreamClass.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(ifs[i]) || (class$java$rmi$Remote == null ? RMIRemoteStreamClass.class$("java.rmi.Remote") : class$java$rmi$Remote).equals(ifs[i])) {
                        ifs[i] = null;
                    } else {
                        boolean found = false;
                        ListIterator<Class<?>> itt = tops.listIterator();
                        while (itt.hasNext()) {
                            Class t = (Class)itt.next();
                            if (ifs[i].isAssignableFrom(t)) {
                                found = true;
                                break;
                            }
                            if (!t.isAssignableFrom(ifs[i])) continue;
                            itt.set(ifs[i]);
                            found = true;
                            break;
                        }
                        if (!found) {
                            tops.add(ifs[i]);
                        }
                    }
                    ++i;
                }
            }
        }
        Class lc = null;
        if (sup != null) {
            lc = RMIRemoteStreamClass.getMostDerived(sup, leaf, tops);
        }
        int i = 0;
        while (i < ifs.length && lc == null) {
            if (ifs[i] != null) {
                lc = RMIRemoteStreamClass.getMostDerived(ifs[i], leaf, tops);
            }
            ++i;
        }
        while (i < ifs.length) {
            if (ifs[i] != null && RMIRemoteStreamClass.getMostDerived(ifs[i], leaf, tops) != null) {
                lc = null;
            }
            ++i;
        }
        if (isIfc) {
            leaf.add(clz);
            return clz;
        }
        return lc == null ? clz : lc;
    }

    private static Map getStreamClassesMap() {
        HashMap<Class, RMIRemoteStreamClass> map = (HashMap<Class, RMIRemoteStreamClass>)STREAM_CLASSES.get();
        if (map == null) {
            map = new HashMap<Class, RMIRemoteStreamClass>();
            map.put(class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote, RC);
            STREAM_CLASSES.set(map);
        }
        return map;
    }

    private static void addToCache(Class clz, RMIRemoteStreamClass strclz) {
        Map map = RMIRemoteStreamClass.getStreamClassesMap();
        map.put(clz, strclz);
        Map map2 = GLOBAL_CLASSES;
        synchronized (map2) {
            if (GLOBAL_CLASSES.get(clz) == null) {
                GLOBAL_CLASSES.put(clz, strclz);
            }
        }
    }

    private static RMIRemoteStreamClass getFromCache(Class clz) {
        Map map = RMIRemoteStreamClass.getStreamClassesMap();
        RMIRemoteStreamClass strclz = (RMIRemoteStreamClass)map.get(clz);
        if (strclz == null) {
            Map map2 = GLOBAL_CLASSES;
            synchronized (map2) {
                strclz = (RMIRemoteStreamClass)GLOBAL_CLASSES.get(clz);
            }
            if (strclz != null) {
                map.put(clz, strclz);
            }
        }
        return strclz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RMIRemoteStreamClass.RC.m_implementation_class = class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote;
        RMIRemoteStreamClass.RC.m_remote_interface_classes = new Class[]{class$java$rmi$Remote == null ? (class$java$rmi$Remote = RMIRemoteStreamClass.class$("java.rmi.Remote")) : class$java$rmi$Remote};
        RMIRemoteStreamClass.RC.m_stub_classes = new Class[]{class$org$openorb$orb$rmi$_Remote_Stub == null ? (class$org$openorb$orb$rmi$_Remote_Stub = RMIRemoteStreamClass.class$("org.openorb.orb.rmi._Remote_Stub")) : class$org$openorb$orb$rmi$_Remote_Stub};
        RMIRemoteStreamClass.RC.m_repository_ids = new String[]{"IDL:omg.org/CORBA/Object:1.0"};
        RMIRemoteStreamClass.RC.m_types = new TypeCode[]{s_orb.get_primitive_tc(TCKind.tk_objref)};
    }
}

