/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;
import org.openorb.orb.core.ORBSingleton;

public class StubDelegateImpl
implements StubDelegate {
    private transient IOR m_ior;

    public StubDelegateImpl() {
    }

    public StubDelegateImpl(IOR ior) {
        this.m_ior = ior;
    }

    public int hashCode(Stub self) {
        return self._hash(32);
    }

    public boolean equals(Stub self, java.lang.Object obj) {
        if (obj == self) {
            return true;
        }
        if (obj instanceof Object) {
            return ((ObjectImpl)obj)._is_equivalent((Object)self);
        }
        return false;
    }

    public String toString(Stub self) {
        try {
            Delegate deleg = self._get_delegate();
            return deleg.toString((Object)self);
        }
        catch (BAD_OPERATION ex) {
            return this.getClass().getName() + ":no delegate set";
        }
    }

    public void connect(Stub self, ORB orb) throws RemoteException {
        try {
            self._get_delegate();
            if (!self._orb().equals(orb)) {
                throw new RemoteException("Already connected to other orb");
            }
        }
        catch (BAD_OPERATION ex) {
            if (this.m_ior == null) {
                Logger logger = null;
                if (self._orb() instanceof ORBSingleton && (logger = ((ORBSingleton)self._orb()).getLogger()) != null && logger.isErrorEnabled()) {
                    logger.getChildLogger("rmi").error("Connection failed. Not deserialized.", (Throwable)ex);
                }
                throw new RemoteException("Connection failed. Not deserialized (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
            org.openorb.orb.core.Delegate deleg = new org.openorb.orb.core.Delegate(orb, this.m_ior);
            self._set_delegate((Delegate)deleg);
        }
    }

    public void writeObject(Stub self, ObjectOutputStream s) throws IOException {
        IOR ior = this.m_ior;
        if (ior == null) {
            Delegate deleg;
            try {
                deleg = self._get_delegate();
            }
            catch (BAD_OPERATION ex) {
                Logger logger = null;
                if (self._orb() instanceof ORBSingleton && (logger = ((ORBSingleton)self._orb()).getLogger()) != null && logger.isErrorEnabled()) {
                    logger.getChildLogger("rmi").error("Object not exported.", (Throwable)ex);
                }
                throw new IllegalStateException("Object not exported (" + (java.lang.Object)((java.lang.Object)ex) + ")");
            }
            if (!(deleg instanceof org.openorb.orb.core.Delegate)) {
                throw new IllegalStateException("Object not exported to openorb orb.");
            }
            ior = this.m_ior = ((org.openorb.orb.core.Delegate)deleg).ior();
        }
        s.writeInt(ior.type_id.length());
        byte[] ior_buffer = ior.type_id.getBytes();
        s.write(ior_buffer, 0, ior_buffer.length);
        s.writeInt(ior.profiles.length);
        int i = 0;
        while (i < ior.profiles.length) {
            s.writeInt(ior.profiles[i].tag);
            s.writeInt(ior.profiles[i].profile_data.length);
            s.write(ior.profiles[i].profile_data, 0, ior.profiles[i].profile_data.length);
            ++i;
        }
    }

    public void readObject(Stub self, ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_ior = new IOR();
        int size = s.readInt();
        byte[] ior_buffer = new byte[size];
        s.read(ior_buffer, 0, size);
        this.m_ior.type_id = new String(ior_buffer);
        size = s.readInt();
        this.m_ior.profiles = new TaggedProfile[size];
        int i = 0;
        while (i < this.m_ior.profiles.length) {
            this.m_ior.profiles[i] = new TaggedProfile();
            this.m_ior.profiles[i].tag = s.readInt();
            size = s.readInt();
            this.m_ior.profiles[i].profile_data = new byte[size];
            s.read(this.m_ior.profiles[i].profile_data, 0, this.m_ior.profiles[i].profile_data.length);
            ++i;
        }
    }
}

