/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.PortableRemoteObject;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import org.openorb.orb.core.ORB;
import org.openorb.orb.core.ORBSingleton;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.rmi.CORBAIOException;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.rmi.PortableRemoteObjectDelegateImpl;
import org.openorb.orb.rmi.RMIObjectStreamClass;
import org.openorb.orb.rmi.RMIRemoteStreamClass;
import org.openorb.orb.rmi.ValueHandlerImpl;
import org.openorb.orb.util.Trace;
import org.openorb.util.ExceptionTool;
import org.openorb.util.IdentityKey;

public class UtilDelegateImpl
implements UtilDelegate,
LogEnabled {
    private static final java.lang.Object SYNC_INSTANCE = new java.lang.Object();
    private static UtilDelegateImpl s_instance;
    private static Logger s_logger;
    private static boolean s_local_codebase_only;
    private static boolean s_prohibit_is_local_test;
    private static boolean s_is_local_result;
    private static boolean s_copy_local_objects;
    private static Map s_exported_objects;
    private static ORBSingleton s_orb;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;

    public UtilDelegateImpl() {
        UtilDelegateImpl.createUtilDelegate();
    }

    private UtilDelegateImpl(boolean dummy) {
    }

    public static UtilDelegate createUtilDelegate() {
        java.lang.Object object = SYNC_INSTANCE;
        synchronized (object) {
            if (s_instance == null) {
                s_instance = new UtilDelegateImpl(true);
                s_instance.enableLogging(((ORB)DefaultORB.getORB()).getLogger().getChildLogger("ud"));
            }
        }
        return s_instance;
    }

    public void enableLogging(Logger logger) {
        s_logger = logger;
    }

    public Logger getLogger() {
        return s_logger;
    }

    public RemoteException mapSystemException(SystemException ex) {
        String message_pre = "CORBA ";
        String message_post = " 0x" + Integer.toHexString(ex.minor) + " ";
        switch (ex.completed.value()) {
            case 2: {
                message_post = message_post + "Maybe";
                break;
            }
            case 1: {
                message_post = message_post + "No";
                break;
            }
            case 0: {
                message_post = message_post + "Yes";
            }
        }
        if (ex instanceof COMM_FAILURE) {
            return new MarshalException(message_pre + "COMM_FAILURE" + message_post);
        }
        if (ex instanceof INV_OBJREF) {
            return new NoSuchObjectException(message_pre + "INV_OBJREF" + message_post);
        }
        if (ex instanceof NO_PERMISSION) {
            return new AccessException(message_pre + "NO_PERMISSION" + message_post);
        }
        if (ex instanceof MARSHAL) {
            return new MarshalException(message_pre + "MARSHAL" + message_post);
        }
        if (ex instanceof OBJECT_NOT_EXIST) {
            return new NoSuchObjectException(message_pre + "OBJECT_NOT_EXIST" + message_post);
        }
        if (ex instanceof OBJ_ADAPTER) {
            return new NoSuchObjectException(message_pre + "OBJ_ADAPTER" + message_post);
        }
        if (ex instanceof BAD_PARAM) {
            if (ex.minor == 1330446342) {
                return new RemoteException(message_pre + "BAD_PARAM" + message_post, new NotSerializableException(message_pre + "BAD_PARAM" + message_post));
            }
            return new MarshalException(message_pre + "BAD_PARAM" + message_post);
        }
        try {
            if (ex instanceof TRANSACTION_REQUIRED) {
                return (RemoteException)Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.TransactionRequiredException").getConstructor(class$java$lang$String == null ? (class$java$lang$String = UtilDelegateImpl.class$("java.lang.String")) : class$java$lang$String).newInstance(message_pre + "TRANSACTION_REQUIRED" + message_post);
            }
            if (ex instanceof TRANSACTION_ROLLEDBACK) {
                return (RemoteException)Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.TransactionRolledbackException").getConstructor(class$java$lang$String == null ? (class$java$lang$String = UtilDelegateImpl.class$("java.lang.String")) : class$java$lang$String).newInstance(message_pre + "TRANSACTION_ROLLEDBACK" + message_post);
            }
            if (ex instanceof INVALID_TRANSACTION) {
                return (RemoteException)Thread.currentThread().getContextClassLoader().loadClass("javax.transaction.InvalidTransactionException").getConstructor(class$java$lang$String == null ? (class$java$lang$String = UtilDelegateImpl.class$("java.lang.String")) : class$java$lang$String).newInstance(message_pre + "INVALID_TRANSACTION" + message_post);
            }
        }
        catch (Exception ex1) {
            throw ExceptionTool.initCause((RuntimeException)new RuntimeException("Unable to instantiate an exception from the package javax.transaction!"), (Throwable)ex1);
        }
        if (ex instanceof UnknownException) {
            UnknownException uex = (UnknownException)ex;
            if (uex.originalEx instanceof Error) {
                return new ServerError(message_pre + "UNKNOWN" + message_post, (Error)uex.originalEx);
            }
            if (uex.originalEx instanceof RuntimeException) {
                throw (RuntimeException)uex.originalEx;
            }
            if (uex.originalEx instanceof RemoteException) {
                return new ServerException(message_pre + "UNKNOWN" + message_post, (Exception)uex.originalEx);
            }
            return new RemoteException(message_pre + "UNKNOWN" + message_post, (Exception)uex.originalEx);
        }
        String name = ((java.lang.Object)((java.lang.Object)ex)).getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return new RemoteException(message_pre + name + message_post);
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream out, final java.lang.Object obj) {
        TypeCode tc;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeAny( " + out + ", " + obj + " )");
        }
        if ((tc = (TypeCode)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                try {
                    return UtilDelegateImpl.lookupRuntimeTypeCode(obj);
                }
                catch (InvalidClassException ex) {
                    throw UtilDelegateImpl.mapIOSysException(ex);
                }
            }
        })) == null) {
            throw new MARSHAL();
        }
        out.write_TypeCode(tc);
        switch (tc.kind().value()) {
            case 32: {
                ((OutputStream)out).write_abstract_interface((java.lang.Object)((Serializable)obj));
                break;
            }
            case 14: {
                this.writeRemoteObject(out, obj);
                break;
            }
            case 29: 
            case 30: {
                ((OutputStream)out).write_value((Serializable)obj);
                break;
            }
            default: {
                throw new MARSHAL();
            }
        }
    }

    public java.lang.Object readAny(org.omg.CORBA.portable.InputStream in) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("readAny( " + in + " )");
        }
        TypeCode tc = in.read_TypeCode();
        while (tc.kind() == TCKind.tk_alias) {
            try {
                tc = tc.content_type();
            }
            catch (BadKind ex) {
                throw new Error("Should be impossible");
            }
        }
        switch (tc.kind().value()) {
            case 32: {
                return ((InputStream)in).read_abstract_interface();
            }
            case 30: {
                if (tc.equal(WStringValueHelper.type())) {
                    return ((InputStream)in).read_value((BoxedValueHelper)new WStringValueHelper());
                }
            }
            case 29: {
                return ((InputStream)in).read_value();
            }
            case 14: {
                return in.read_Object();
            }
        }
        throw new IllegalArgumentException("Illegal any contents");
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeRemoteObject( " + out + ", " + obj + " )");
        }
        if (obj != null && obj instanceof Remote) {
            out.write_Object(UtilDelegateImpl.exportRemote(out, (Remote)obj));
        } else if (obj == null || obj instanceof Object) {
            out.write_Object((Object)obj);
        } else {
            throw new IllegalArgumentException("Not a remote object");
        }
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeAbstractObject( " + out + ", " + obj + " )");
        }
        if (obj != null && obj instanceof Remote) {
            obj = UtilDelegateImpl.exportRemote(out, (Remote)obj);
        }
        ((OutputStream)out).write_abstract_interface(obj);
    }

    public void registerTarget(Tie tie, Remote target) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("registerTarget( " + tie + ", " + target + " )");
        }
        IdentityKey key = new IdentityKey((java.lang.Object)target);
        org.omg.CORBA.ORB orb = tie.orb();
        if (orb == null) {
            throw new IllegalStateException("Tie class is not connected to orb");
        }
        Map map = s_exported_objects;
        synchronized (map) {
            if (s_exported_objects.get(key) != null) {
                return;
            }
            boolean isPOA = tie instanceof Servant;
            ORBDaemon orbKey = new ORBDaemon(orb);
            ORBDaemon daemon = (ORBDaemon)s_exported_objects.get(orbKey);
            if (daemon == null) {
                daemon = orbKey;
                s_exported_objects.put(orbKey, orbKey);
                if (isPOA) {
                    this.initPOA(orb);
                }
            }
            daemon.increment();
            if (isPOA) {
                ((org.omg.CORBA_2_3.ORB)orb).set_delegate((java.lang.Object)tie);
            }
            s_exported_objects.put(key, tie);
        }
        tie.setTarget(target);
    }

    private void initPOA(org.omg.CORBA.ORB orb) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("initPOA( " + orb + " )");
        }
        try {
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
        }
        catch (InvalidName ex) {
            throw new INITIALIZE("POA not found");
        }
        catch (AdapterInactive ex) {
            throw new BAD_INV_ORDER("RootPOA has been deactivated");
        }
    }

    public void unexportObject(Remote target) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("unexportObject( " + target + " )");
        }
        IdentityKey key = new IdentityKey((java.lang.Object)target);
        Map map = s_exported_objects;
        synchronized (map) {
            Tie tie = (Tie)s_exported_objects.get(key);
            if (tie == null) {
                return;
            }
            s_exported_objects.remove(key);
            tie.setTarget(null);
            try {
                tie.deactivate();
            }
            catch (Exception ex) {
                // empty catch block
            }
            IdentityKey orbKey = new IdentityKey((java.lang.Object)tie.orb());
            ORBDaemon daemon = (ORBDaemon)s_exported_objects.get(orbKey);
            if (daemon.decrement()) {
                s_exported_objects.remove(orbKey);
            }
        }
    }

    public Tie getTie(Remote target) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("getTie( " + target + " )");
        }
        if (target instanceof Stub) {
            return null;
        }
        if (target instanceof Tie) {
            return (Tie)target;
        }
        IdentityKey key = new IdentityKey((java.lang.Object)target);
        Map map = s_exported_objects;
        synchronized (map) {
            Tie tie = (Tie)s_exported_objects.get(key);
            return tie;
        }
    }

    public ValueHandler createValueHandler() {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("createValueHandler()");
        }
        return ValueHandlerImpl.createValueHandler(this.getLogger().getChildLogger("vh"));
    }

    public RemoteException wrapException(Throwable obj) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("wrapException( " + obj + " )");
        }
        if (obj instanceof SystemException) {
            return this.mapSystemException((SystemException)obj);
        }
        if (obj instanceof Error) {
            return new ServerError("Error exception in Server", (Error)obj);
        }
        if (obj instanceof RemoteException) {
            return new ServerException("RemoteException in Server");
        }
        if (obj instanceof RuntimeException) {
            throw (RuntimeException)obj;
        }
        throw new BAD_PARAM();
    }

    public java.lang.Object copyObject(java.lang.Object obj, org.omg.CORBA.ORB orb) throws RemoteException {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("copyObject( " + obj + ", " + orb + " )");
        }
        if (!UtilDelegateImpl.getCopyLocalObjects()) {
            return obj;
        }
        if (obj == null) {
            return null;
        }
        Class<?> clz = obj.getClass();
        UnknownException new_obj = null;
        if (clz.isPrimitive() || obj instanceof String) {
            return obj;
        }
        if (clz.isArray()) {
            Class<?> cmpt = clz.getComponentType();
            if (cmpt.isPrimitive()) {
                if (cmpt.equals(Boolean.TYPE)) {
                    return ((boolean[])obj).clone();
                }
                if (cmpt.equals(Character.TYPE)) {
                    return ((char[])obj).clone();
                }
                if (cmpt.equals(Byte.TYPE)) {
                    return ((byte[])obj).clone();
                }
                if (cmpt.equals(Short.TYPE)) {
                    return ((short[])obj).clone();
                }
                if (cmpt.equals(Integer.TYPE)) {
                    return ((int[])obj).clone();
                }
                if (cmpt.equals(Long.TYPE)) {
                    return ((long[])obj).clone();
                }
                if (cmpt.equals(Float.TYPE)) {
                    return ((float[])obj).clone();
                }
                if (cmpt.equals(Double.TYPE)) {
                    return ((double[])obj).clone();
                }
            }
            if (cmpt.equals(class$java$lang$String == null ? (class$java$lang$String = UtilDelegateImpl.class$("java.lang.String")) : class$java$lang$String)) {
                return ((String[])obj).clone();
            }
            return this.copyObjects((java.lang.Object[])obj, orb);
        }
        if (obj instanceof Object) {
            try {
                ((ObjectImpl)obj)._get_delegate();
                return obj;
            }
            catch (BAD_OPERATION ex) {
                orb.connect((Object)obj);
                return obj;
            }
        }
        if (obj instanceof Remote) {
            if (obj instanceof Stub) {
                try {
                    ((Stub)obj)._get_delegate();
                    return obj;
                }
                catch (BAD_OPERATION ex) {
                    ((Stub)obj).connect(orb);
                    return obj;
                }
            }
            Tie tie = this.getTie((Remote)obj);
            if (tie == null) {
                throw new INV_OBJREF("Couldn get the tie from obj! " + obj);
            }
            if (tie.orb() == null) {
                tie.orb(orb);
                Util.registerTarget((Tie)tie, (Remote)((Remote)obj));
            }
            return PortableRemoteObject.toStub((Remote)((Remote)obj));
        }
        if (obj instanceof SystemException) {
            try {
                new_obj = obj instanceof UnknownException ? new UnknownException(((UnknownException)obj).originalEx) : (UnknownException)clz.newInstance();
                SystemException sys = (SystemException)new_obj;
                sys.completed = ((SystemException)((java.lang.Object)obj)).completed;
                sys.minor = ((SystemException)((java.lang.Object)obj)).minor;
                return new_obj;
            }
            catch (Exception ex) {
                throw new BAD_PARAM("An exception occured while creating a CORBA SystemException from '" + clz.getName() + "': " + ex);
            }
        }
        if (obj instanceof Serializable) {
            if (obj instanceof ValueBase) {
                Codec codec = this.initCodec(orb);
                Any any = orb.create_any();
                any.insert_Value((Serializable)obj);
                try {
                    byte[] enc = codec.encode_value(any);
                    any = codec.decode_value(enc, orb.get_primitive_tc(TCKind.tk_value));
                }
                catch (UserException ex) {
                    throw new Error(ex.toString());
                }
                return any.extract_Value();
            }
            try {
                OutputStream out = (OutputStream)orb.create_output_stream();
                out.write_value((Serializable)obj);
                InputStream in = (InputStream)out.create_input_stream();
                return in.read_value();
            }
            catch (ClassCastException ex) {
                throw new MarshalException("Exception occurred during copyObject() method: " + ex, new NotSerializableException());
            }
            catch (SystemException ex) {
                throw this.mapSystemException(ex);
            }
        }
        throw new BAD_PARAM("The object is not a of a type that is supported by the marshaling engine of RMI-IIOP. The copyObject() operation failed.");
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] obj, org.omg.CORBA.ORB orb) throws RemoteException {
        int i;
        Class<?>[] itfs;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("copyObjects( " + obj + ", " + orb + " )");
        }
        if (!UtilDelegateImpl.getCopyLocalObjects()) {
            return obj;
        }
        if (obj == null) {
            return obj;
        }
        Class<?> cmpt = obj.getClass().getComponentType();
        if (cmpt.equals(class$java$lang$String == null ? (class$java$lang$String = UtilDelegateImpl.class$("java.lang.String")) : class$java$lang$String)) {
            return (String[])((String[])obj).clone();
        }
        if (!(cmpt.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = UtilDelegateImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cmpt) || (itfs = cmpt.getInterfaces()) == null || itfs.length <= 0)) {
            i = 0;
            while (i < itfs.length) {
                if ((class$java$rmi$Remote == null ? UtilDelegateImpl.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(itfs[i])) {
                    cmpt = itfs[i];
                }
                ++i;
            }
        }
        java.lang.Object[] ret = (java.lang.Object[])Array.newInstance(cmpt, obj.length);
        if (cmpt.isArray()) {
            i = 0;
            while (i < obj.length) {
                ret[i] = this.copyObjects((java.lang.Object[])obj[i], orb);
                ++i;
            }
        } else {
            i = 0;
            while (i < obj.length) {
                ret[i] = this.copyObject(obj[i], orb);
                ++i;
            }
        }
        return ret;
    }

    private Codec initCodec(org.omg.CORBA.ORB orb) {
        CodecFactory cf;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("initCodec( " + orb + " )");
        }
        try {
            cf = (CodecFactory)orb.resolve_initial_references("CodecFactory");
        }
        catch (InvalidName ex) {
            throw new Error(ex.toString());
        }
        try {
            return cf.create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding ex) {
            throw new Error(ex.toString());
        }
    }

    public boolean isLocal(Stub s) throws RemoteException {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("isLocal( " + s + " )");
        }
        if (UtilDelegateImpl.getProhibitIsLocalTest()) {
            return s_is_local_result;
        }
        try {
            return s._is_local();
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public String getCodebase(Class clz) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("getCodebase( " + clz + " )");
        }
        return RMIClassLoader.getClassAnnotation(clz);
    }

    public Class loadClass(String className, String remoteCodebase, Class loadingContext) throws ClassNotFoundException {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("loadClass( " + className + ", " + remoteCodebase + ", " + loadingContext + " )");
        }
        try {
            Class<?> ret;
            block22: {
                block21: {
                    block20: {
                        ret = null;
                        try {
                            ret = Thread.currentThread().getContextClassLoader().loadClass(className);
                            if (loadingContext == null || loadingContext.isAssignableFrom(ret)) {
                                return ret;
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            if (!this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block20;
                            this.getLogger().debug("Attempt (1) to load the class using the current Thread's context ClassLoader failed.");
                        }
                    }
                    if (remoteCodebase != null && !s_local_codebase_only) {
                        try {
                            ret = RMIClassLoader.loadClass(remoteCodebase, className);
                            if (loadingContext == null || loadingContext.isAssignableFrom(ret)) {
                                return ret;
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                                this.getLogger().debug("Attempt (2) to load the class via the RMIClassLoader failed as well.");
                            }
                        }
                        catch (MalformedURLException ex) {
                            if (!this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block21;
                            this.getLogger().debug("Attempt (2) to load the class via the RMIClassLoader failed as well.");
                        }
                    }
                }
                try {
                    ret = RMIClassLoader.loadClass((String)null, className);
                    if (loadingContext.isAssignableFrom(ret)) {
                        return ret;
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug("Attempt (3) to load the class via the RMIClassLoader failed as well.");
                    }
                }
                catch (MalformedURLException ex) {
                    if (!this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block22;
                    this.getLogger().debug("Attempt (3) to load the class via the RMIClassLoader failed as well.");
                }
            }
            if (loadingContext != null && loadingContext.isAssignableFrom(ret = Class.forName(className, false, loadingContext.getClassLoader()))) {
                return ret;
            }
            if (ret != null) {
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("Attempt (4) to load the class via the system ClassLoader failed as well.");
                }
                throw new ClassNotFoundException("Loaded class was not compatible with desired class");
            }
        }
        catch (Throwable th) {
            this.getLogger().error("An unexpected exception occured!", th);
        }
        throw new ClassNotFoundException("Could not load class");
    }

    public Class loadClass(String className, String remoteCodebase, ClassLoader loadingContext) throws ClassNotFoundException {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("loadClass( " + className + ", " + remoteCodebase + ", " + loadingContext + " )");
        }
        try {
            try {
                return Class.forName(className, false, null);
            }
            catch (ClassNotFoundException ex) {
                block19: {
                    block18: {
                        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                            this.getLogger().debug("Attempt (1) to load the class using the current Thread's context ClassLoader failed.");
                        }
                        if (remoteCodebase != null && !s_local_codebase_only) {
                            try {
                                return RMIClassLoader.loadClass(remoteCodebase, className);
                            }
                            catch (ClassNotFoundException ex2) {
                                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                                    this.getLogger().debug("Attempt (2) to load the class via the RMIClassLoader failed as well.");
                                }
                            }
                            catch (MalformedURLException ex3) {
                                if (!this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block18;
                                this.getLogger().debug("Attempt (2) to load the class via the RMIClassLoader failed as well.");
                            }
                        }
                    }
                    if (!s_local_codebase_only) {
                        try {
                            return RMIClassLoader.loadClass((String)null, className);
                        }
                        catch (ClassNotFoundException ex4) {
                            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                                this.getLogger().debug("Attempt (3) to load the class via the RMIClassLoader failed as well.");
                            }
                        }
                        catch (MalformedURLException ex5) {
                            if (!this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block19;
                            this.getLogger().debug("Attempt (3) to load the class via the RMIClassLoader failed as well.");
                        }
                    }
                }
                if (loadingContext != null) {
                    return Class.forName(className, false, loadingContext);
                }
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("Attempt (4) to load the class via the system ClassLoader failed as well.");
                }
            }
        }
        catch (Throwable th) {
            this.getLogger().error("An unexpected exception occured!", th);
        }
        throw new ClassNotFoundException("Couldn't load class '" + className + "'!");
    }

    static SystemException mapIOSysException(IOException ex) {
        if (ex instanceof CORBAIOException) {
            return ((CORBAIOException)ex).getTargetException();
        }
        return new MARSHAL(ex.toString());
    }

    static IOException mapSysIOException(SystemException ex) {
        Throwable target;
        if (ex instanceof UnknownException && (target = ((UnknownException)ex).originalEx) instanceof IOException) {
            return (IOException)target;
        }
        return new CORBAIOException(ex);
    }

    static Class locateHelperClass(Class clz) {
        while ((class$org$omg$CORBA$portable$IDLEntity == null ? UtilDelegateImpl.class$("org.omg.CORBA.portable.IDLEntity") : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz)) {
            try {
                return Util.loadClass((String)(clz.getName() + "Helper"), (String)Util.getCodebase(clz), (ClassLoader)clz.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                clz = clz.getSuperclass();
            }
        }
        return null;
    }

    private org.omg.CORBA.ORB getORB(org.omg.CORBA.portable.OutputStream out) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("getORB( " + out + " )");
        }
        if (out instanceof CDROutputStream) {
            return ((CDROutputStream)out).orb();
        }
        return DefaultORB.getORB();
    }

    static Object exportRemote(org.omg.CORBA.portable.OutputStream out, Remote obj) {
        if (s_instance.getLogger().isDebugEnabled() && Trace.isLow()) {
            s_instance.getLogger().debug("exportRemote( " + out + ", " + obj + " )");
        }
        try {
            if (obj instanceof Stub) {
                Stub stub = (Stub)obj;
                try {
                    stub._get_delegate();
                }
                catch (BAD_OPERATION ex) {
                    stub.connect(s_instance.getORB(out));
                }
                return stub;
            }
            Tie tie = s_instance.getTie(obj);
            if (tie == null) {
                tie = PortableRemoteObjectDelegateImpl.loadTie(obj);
                tie.orb(s_instance.getORB(out));
                s_instance.registerTarget(tie, obj);
            }
            return tie.thisObject();
        }
        catch (IOException ex) {
            throw UtilDelegateImpl.mapIOSysException(ex);
        }
    }

    public static TypeCode lookupRuntimeTypeCode(java.lang.Object obj) throws InvalidClassException {
        if (obj == null) {
            return s_orb.create_abstract_interface_tc("IDL:omg.org/CORBA/AbstractBase:1.0", "");
        }
        if (obj instanceof Object) {
            ObjectImpl impl;
            String[] ids;
            if (obj instanceof ObjectImpl && (ids = (impl = (ObjectImpl)obj)._ids()).length > 0) {
                return s_orb.create_interface_tc(ids[0], "");
            }
            return s_orb.get_primitive_tc(TCKind.tk_objref);
        }
        if (obj instanceof Remote) {
            RMIRemoteStreamClass rsc = RMIRemoteStreamClass.lookup(obj.getClass());
            if (rsc == null) {
                return null;
            }
            return rsc.getInterfaceTypesNoCopy()[0];
        }
        if (!(obj instanceof Serializable)) {
            return null;
        }
        if (obj instanceof ValueBase) {
            if (obj instanceof Streamable) {
                return ((Streamable)obj)._type();
            }
            Class helper = UtilDelegateImpl.locateHelperClass(obj.getClass());
            try {
                return (TypeCode)helper.getMethod("type", new Class[0]).invoke(null, new java.lang.Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable real = ex.getTargetException();
                if (real instanceof RuntimeException) {
                    throw (RuntimeException)real;
                }
                if (real instanceof Error) {
                    throw (Error)real;
                }
                throw new InvalidClassException(helper.getName(), real.toString());
            }
            catch (IllegalAccessException ex) {
                throw new InvalidClassException(helper.getName(), "IllegalAccessException");
            }
            catch (NoSuchMethodException ex) {
                throw new InvalidClassException(helper.getName(), "NoSuchMethodException");
            }
        }
        RMIObjectStreamClass osc = RMIObjectStreamClass.lookup(obj.getClass());
        return osc.type();
    }

    public static boolean getIsLocalResult() {
        return s_is_local_result;
    }

    public static void setIsLocalResult(boolean is_local_result) {
        s_is_local_result = is_local_result;
    }

    public static boolean getProhibitIsLocalTest() {
        return s_prohibit_is_local_test;
    }

    public static void setProhibitIsLocalTest(boolean prohibit_is_local_test) {
        s_prohibit_is_local_test = prohibit_is_local_test;
    }

    public static boolean getLocalCodebaseOnly() {
        return s_local_codebase_only;
    }

    public static void setLocalCodebaseOnly(boolean local_codebase_only) {
        s_local_codebase_only = local_codebase_only;
    }

    public static boolean getCopyLocalObjects() {
        return s_copy_local_objects;
    }

    public static void setCopyLocalObjects(boolean copy_local_objects) {
        s_copy_local_objects = copy_local_objects;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_local_codebase_only = false;
        s_prohibit_is_local_test = false;
        s_is_local_result = false;
        s_copy_local_objects = true;
        s_exported_objects = new HashMap();
        s_orb = new ORBSingleton();
    }

    private static class ORBDaemon
    extends IdentityKey
    implements Runnable {
        private Thread m_thread = null;
        private org.omg.CORBA.ORB m_orb;
        private int m_count = 0;

        ORBDaemon(org.omg.CORBA.ORB orb) {
            super((java.lang.Object)orb);
            this.m_orb = orb;
        }

        public void run() {
            this.m_orb.run();
        }

        void increment() {
            if (this.m_count++ == 0) {
                this.m_thread = new Thread((Runnable)this, "ORBDaemon [" + this.m_orb + "]");
                this.m_thread.setDaemon(true);
                this.m_thread.start();
            }
        }

        boolean decrement() {
            if (--this.m_count <= 0) {
                this.m_thread.interrupt();
                return true;
            }
            return false;
        }
    }
}

