/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.RunTime;
import org.omg.SendingContext._CodeBaseStub;
import org.openorb.orb.iiop.CDRInputStream;
import org.openorb.orb.iiop.CDROutputStream;
import org.openorb.orb.rmi.DeserializationKernel;
import org.openorb.orb.rmi.DeserializationKernelFactory;
import org.openorb.orb.rmi.PortableRemoteObjectDelegateImpl;
import org.openorb.orb.rmi.RMIObjectInputStream;
import org.openorb.orb.rmi.RMIObjectOutputStream;
import org.openorb.orb.rmi.RMIObjectStreamClass;
import org.openorb.orb.rmi.UtilDelegateImpl;
import org.openorb.orb.util.Trace;
import org.openorb.util.CharacterCache;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;

public final class ValueHandlerImpl
extends AbstractLogEnabled
implements ValueHandler {
    private static final Object SYNC_INSTANCE = new Object();
    private static ValueHandlerImpl s_value_handler_instance;
    private static DeserializationKernel s_kernel;
    private static WStringValueHelper s_string_helper;
    private static ThreadLocal s_ri_local;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ObjectImpl;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;

    private ValueHandlerImpl() {
        if (s_value_handler_instance != null) {
            throw new Error("Multiple copies of ValueHandlerImpl instantiated");
        }
    }

    public static synchronized ValueHandlerImpl createValueHandler(Logger logger) {
        if (s_value_handler_instance == null) {
            s_value_handler_instance = new ValueHandlerImpl();
            s_value_handler_instance.enableLogging(logger);
        }
        return s_value_handler_instance;
    }

    public void writeValue(org.omg.CORBA.portable.OutputStream out_sub, Serializable value) {
        RMIObjectStreamClass sc;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeValue( " + out_sub + ", " + value + " )");
        }
        OutputStream out = (OutputStream)out_sub;
        if (value instanceof String) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("writeValue: wstring to be written");
            }
            out.write_wstring((String)((Object)value));
            return;
        }
        if (value instanceof Class) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("writeValue: ClassDesc to be written");
            }
            this.writeClassDesc(out, (Class)value);
            return;
        }
        if (value.getClass().isArray()) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("writeValue: array to be written");
            }
            this.writeArray(out, value);
            return;
        }
        if (out instanceof CDROutputStream) {
            sc = ((CDROutputStream)out).getObjectStreamClass();
        } else {
            try {
                sc = RMIObjectStreamClass.lookup(value.getClass());
            }
            catch (InvalidClassException ex) {
                if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Exception looking up the class " + value.getClass().getName() + ".", (Throwable)ex);
                }
                throw new MARSHAL("Exception looking up the class " + value.getClass().getName() + " (" + ex + ")");
            }
        }
        if (sc.isIDLEntity()) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("writeValue: IDLEntity to be written");
            }
            sc.write((org.omg.CORBA.portable.OutputStream)out, value);
            return;
        }
        try {
            RMIObjectOutputStream oos = new RMIObjectOutputStream(this, out);
            if (sc.isExternalizable()) {
                out.write_octet((byte)1);
                ((Externalizable)value).writeExternal(oos);
                return;
            }
            RMIObjectStreamClass[] scc = sc.getAllStreamClasses();
            int i = 0;
            while (i < scc.length) {
                if (scc[i].hasWriteObject()) {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug("writeValue: hasWriteObject scc[" + i + "] = " + scc[i]);
                    }
                    out.write_octet((byte)1);
                    out.write_boolean(false);
                    oos.setContext(value, scc[i]);
                    scc[i].writeObject(value, oos);
                } else {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug("writeValue: defaultWriteObject scc[" + i + "] = " + scc[i]);
                    }
                    this.defaultWriteObject(out, value, scc[i]);
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw UtilDelegateImpl.mapIOSysException(ex);
        }
    }

    public Serializable readValue(org.omg.CORBA.portable.InputStream in_sub, int offset, Class expected, String repoID, RunTime sender) {
        RMIObjectStreamClass sc;
        String clzFromRepoId;
        int idxColon;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("readValue( " + in_sub + ", " + offset + ", " + expected + ", " + repoID + ", " + sender + " )");
        }
        if (expected == (class$java$lang$Object == null ? (class$java$lang$Object = ValueHandlerImpl.class$("java.lang.Object")) : class$java$lang$Object) && repoID != null) {
            expected = null;
        }
        String codebase = null;
        InputStream in = (InputStream)in_sub;
        if (in instanceof CDRInputStream) {
            codebase = ((CDRInputStream)in).getValueCodebase();
        } else {
            Serializable ret;
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: checking for indirection");
            }
            if ((ret = this.checkReadIndirect(offset)) != null) {
                return ret;
            }
        }
        boolean isWString = expected == null ? repoID.equals(WStringValueHelper.id()) : (class$java$lang$String == null ? (class$java$lang$String = ValueHandlerImpl.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(expected);
        if (isWString) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: wstring to be read");
            }
            return in.read_wstring();
        }
        boolean isClassDesc = expected == null ? repoID.startsWith("RMI:javax.rmi.CORBA.ClassDesc:") : (class$java$lang$Class == null ? (class$java$lang$Class = ValueHandlerImpl.class$("java.lang.Class")) : class$java$lang$Class).isAssignableFrom(expected);
        if (isClassDesc) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: ClassDesc to be read");
            }
            return this.readClassDesc(in);
        }
        Class clz = null;
        if (expected != null && (idxColon = repoID.indexOf(58, 4)) != -1 && (clzFromRepoId = repoID.substring(4, idxColon)).equals(expected)) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: clz from the repoID matches the expected class ( repoID=" + repoID + ", expected=" + expected + " )");
            }
            clz = expected;
        }
        if (clz == null) {
            String clzName;
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: We try to get the class from the sending context now ( codebase=" + codebase + ", sender=" + sender + " )");
            }
            if (codebase == null && sender != null) {
                CodeBase cb;
                if (sender instanceof CodeBase) {
                    cb = (CodeBase)sender;
                } else {
                    _CodeBaseStub stub = new _CodeBaseStub();
                    stub._set_delegate(((ObjectImpl)sender)._get_delegate());
                    cb = stub;
                }
                try {
                    codebase = cb.implementation(repoID);
                }
                catch (BAD_OPERATION ex) {
                    // empty catch block
                }
            }
            if ((clzName = RepoIDHelper.unmangleRepoIDtoClassName((String)repoID)) == null) {
                if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Could not convert classname from repository ID: \"" + repoID + "\"");
                }
                throw new MARSHAL("Could not convert classname from repository ID: \"" + repoID + "\"");
            }
            try {
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("readValue: Util.loadClass( " + clzName + ", " + codebase + ", null )");
                }
                clz = Util.loadClass((String)clzName, (String)codebase, (ClassLoader)null);
            }
            catch (ClassNotFoundException ex) {
                if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Couldn't find class " + clzName + ".", (Throwable)ex);
                }
                throw new MARSHAL("Couldn't find class " + clzName + " (" + ex + ")");
            }
        }
        if (clz.isArray()) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: array to be read");
            }
            return this.readArray(in, offset, clz);
        }
        try {
            sc = RMIObjectStreamClass.lookup(clz);
        }
        catch (InvalidClassException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Class is not compatible with serialization: " + clz.toString() + ".", (Throwable)ex);
            }
            throw new MARSHAL("Class is not compatible with serialization: " + clz.toString() + " (" + ex + ")");
        }
        if (sc == null) {
            throw new MARSHAL("Unable to locate serialization data for class: " + clz.toString());
        }
        if (sc.isIDLEntity()) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: IDLEntity to be read");
            }
            return (Serializable)sc.read((org.omg.CORBA.portable.InputStream)in);
        }
        try {
            Serializable value = null;
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: allocateNewObject( " + clz + ", " + sc.getBaseClass() + ")");
            }
            value = (Serializable)s_kernel.allocateNewObject(clz, sc.getBaseClass());
            boolean doPop = this.addReadIndirect(in, offset, value);
            RMIObjectInputStream ois = new RMIObjectInputStream(this, in);
            if (!sc.isExternalizable()) {
                RMIObjectStreamClass[] scc = sc.getAllStreamClasses();
                int i = 0;
                while (i < scc.length) {
                    ois.setContext(value, scc[i]);
                    if (scc[i].hasWriteObject()) {
                        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                            this.getLogger().debug("readValue: hasWriteObject scc[" + i + "] = " + scc[i]);
                        }
                        if (in.read_octet() != 1) {
                            throw new MARSHAL();
                        }
                        if (in.read_boolean()) {
                            this.defaultReadObject(in, value, sc);
                            scc[i].readObject(value, ois);
                        } else if (!scc[i].readObject(value, ois)) {
                            this.defaultReadObject(in, value, scc[i]);
                        }
                    } else if (!scc[i].readObject(value, ois)) {
                        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                            this.getLogger().debug("readValue: defaultReadObject scc[" + i + "] = " + scc[i]);
                        }
                        this.defaultReadObject(in, value, scc[i]);
                    }
                    ++i;
                }
            } else {
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("readValue: Externalizable to be read");
                }
                if (in.read_octet() != 1) {
                    throw new MARSHAL();
                }
                ((Externalizable)value).readExternal(ois);
            }
            if (doPop) {
                this.popReadIndirect();
            }
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: readResolve to be called");
            }
            value = (Serializable)sc.readResolve(value);
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("readValue: Successfully finished ( value = " + value + " )");
            }
            return value;
        }
        catch (ClassNotFoundException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("ClassNotFoundException occured!", (Throwable)ex);
            }
            throw new MARSHAL("ClassNotFoundException occured! (" + ex + ")");
        }
        catch (IOException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("IOException occured!", (Throwable)ex);
            }
            throw UtilDelegateImpl.mapIOSysException(ex);
        }
        catch (Exception ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unknown exception occured!", (Throwable)ex);
            }
            throw new UNKNOWN("Unexpected exception occured! (" + ex + ")");
        }
    }

    public String getRMIRepositoryID(Class clz) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("getRMIRepositoryID( " + clz + " )");
        }
        if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clz)) {
            if ((class$org$omg$CORBA$portable$ObjectImpl == null ? (class$org$omg$CORBA$portable$ObjectImpl = ValueHandlerImpl.class$("org.omg.CORBA.portable.ObjectImpl")) : class$org$omg$CORBA$portable$ObjectImpl).isAssignableFrom(clz)) {
                try {
                    String[] ids = ((ObjectImpl)clz.newInstance())._ids();
                    if (ids.length > 0) {
                        return ids[0];
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return "IDL:omg.org/CORBA/Object:1.0";
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = ValueHandlerImpl.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz)) {
            try {
                RMIObjectStreamClass descrip = RMIObjectStreamClass.lookup(clz);
                if (descrip != null) {
                    return descrip.getRepoID();
                }
            }
            catch (InvalidClassException invalidClassException) {
                // empty catch block
            }
        }
        return "RMI:" + RepoIDHelper.mangleClassName((Class)clz)[0] + ":0000000000000000";
    }

    public boolean isCustomMarshaled(Class clz) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("isCustomMarshaled( " + clz + " )");
        }
        try {
            RMIObjectStreamClass descrip = RMIObjectStreamClass.lookup(clz);
            if (descrip != null) {
                return descrip.isCustomMarshaled();
            }
        }
        catch (InvalidClassException invalidClassException) {
            // empty catch block
        }
        return false;
    }

    public RunTime getRunTimeCodeBase() {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("getRunTimeCodeBase() NOT IMPLEMENTED!");
        }
        return null;
    }

    public Serializable writeReplace(Serializable value) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeReplace( " + value + " )");
        }
        RMIObjectStreamClass descrip = null;
        try {
            if (value != null) {
                descrip = RMIObjectStreamClass.lookup(value.getClass());
            }
        }
        catch (InvalidClassException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Exception while looking up the class " + value.getClass().getName() + ".", (Throwable)ex);
            }
            throw new MARSHAL("Exception while looking up the class " + value.getClass().getName() + " (" + ex + ")");
        }
        if (descrip == null) {
            return value;
        }
        return this.writeReplaceExt(value, descrip);
    }

    public Serializable writeReplaceExt(Serializable value, RMIObjectStreamClass descrip) {
        if (this.getLogger() != null && this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeReplaceExt( " + value + ", " + descrip + " )");
        }
        try {
            Object rpl = descrip.writeReplace(value);
            if (value == rpl) {
                return value;
            }
            if (rpl instanceof Serializable) {
                return (Serializable)rpl;
            }
            throw new MARSHAL("Attempted to write-replace a non-serializable value");
        }
        catch (ObjectStreamException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Exception while writing to object stream.", (Throwable)ex);
            }
            throw new MARSHAL("Exception while writing to object stream (" + ex + ")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void defaultWriteObject(OutputStream os, Serializable value, RMIObjectStreamClass osc) throws NotSerializableException {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("defaultWriteObject( " + os + ", " + value + ", " + osc + " )");
        }
        Field[] fields = osc.getSerializedFields();
        try {
            int i = 0;
            while (i < fields.length) {
                Class<?> ft = fields[i].getType();
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("defaultWriteObject: writing field '" + fields[i].getName() + "' type=" + ft.getName());
                }
                if (ft.isPrimitive()) {
                    if (ft.equals(Boolean.TYPE)) {
                        os.write_boolean(fields[i].getBoolean(value));
                    } else if (ft.equals(Byte.TYPE)) {
                        os.write_octet(fields[i].getByte(value));
                    } else if (ft.equals(Short.TYPE)) {
                        os.write_short(fields[i].getShort(value));
                    } else if (ft.equals(Integer.TYPE)) {
                        os.write_long(fields[i].getInt(value));
                    } else if (ft.equals(Long.TYPE)) {
                        os.write_longlong(fields[i].getLong(value));
                    } else if (ft.equals(Float.TYPE)) {
                        os.write_float(fields[i].getFloat(value));
                    } else if (ft.equals(Double.TYPE)) {
                        os.write_double(fields[i].getDouble(value));
                    } else {
                        if (!ft.equals(Character.TYPE)) throw new Error("Unknown primitive type");
                        os.write_wchar(fields[i].getChar(value));
                    }
                } else {
                    Object fvalue = fields[i].get(value);
                    if (fvalue != null && !(fvalue instanceof Serializable)) {
                        throw new NotSerializableException(fvalue.getClass().getName());
                    }
                    this.writeStreamValue(os, ft, (Serializable)fvalue);
                }
                ++i;
            }
            return;
        }
        catch (IllegalAccessException ex) {
            if (this.getLogger() == null || !this.getLogger().isErrorEnabled()) throw new Error("Illegal access exception (" + ex + ")");
            this.getLogger().error("Illegal access exception.", (Throwable)ex);
            throw new Error("Illegal access exception (" + ex + ")");
        }
        catch (IllegalArgumentException ex) {
            if (this.getLogger() == null || !this.getLogger().isErrorEnabled()) throw new Error("Illegal argument exception (" + ex + ")");
            this.getLogger().error("Illegal argument exception.", (Throwable)ex);
            throw new Error("Illegal argument exception (" + ex + ")");
        }
    }

    ObjectOutputStream.PutField putFields(Serializable value, RMIObjectStreamClass osc) throws IOException {
        return new PutFieldImpl(value, osc);
    }

    void writeFields(OutputStream os, Serializable value, ObjectOutputStream.PutField fields) throws IOException {
        ((PutFieldImpl)fields).write(os);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void defaultReadObject(InputStream is, Serializable value, RMIObjectStreamClass osc) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("defaultReadObject( " + is + ", <value not yet deserialized>, " + osc + " )");
        }
        Field[] fields = osc.getSerializedFields();
        try {
            int i = 0;
            while (i < fields.length) {
                Class<?> ft = fields[i].getType();
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("defaultReadObject: reading field '" + fields[i].getName() + "' type=" + ft.getName());
                }
                if (ft.isPrimitive()) {
                    if (ft.equals(Boolean.TYPE)) {
                        boolean v = is.read_boolean();
                        s_kernel.setBooleanField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Byte.TYPE)) {
                        byte v = is.read_octet();
                        s_kernel.setByteField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Short.TYPE)) {
                        short v = is.read_short();
                        s_kernel.setShortField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Integer.TYPE)) {
                        int v = is.read_long();
                        s_kernel.setIntField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Long.TYPE)) {
                        long v = is.read_longlong();
                        s_kernel.setLongField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Float.TYPE)) {
                        float v = is.read_float();
                        s_kernel.setFloatField(osc.forClass(), fields[i].getName(), value, v);
                    } else if (ft.equals(Double.TYPE)) {
                        double v = is.read_double();
                        s_kernel.setDoubleField(osc.forClass(), fields[i].getName(), value, v);
                    } else {
                        if (!ft.equals(Character.TYPE)) throw new Error("Unknown primitive type");
                        char v = is.read_wchar();
                        s_kernel.setCharField(osc.forClass(), fields[i].getName(), value, v);
                    }
                } else {
                    Object v = this.readStreamValue(is, ft);
                    if (v != null) {
                        s_kernel.setObjectField(osc.forClass(), fields[i].getName(), value, v);
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception ex) {
            if (this.getLogger() == null || !this.getLogger().isErrorEnabled()) throw new Error("Impossible exception occured (" + ex + ")");
            this.getLogger().error("Impossible exception occured.", (Throwable)ex);
            throw new Error("Impossible exception occured (" + ex + ")");
        }
    }

    ObjectInputStream.GetField readFields(InputStream is, Serializable value, RMIObjectStreamClass osc) {
        return new GetFieldImpl(osc, is);
    }

    private void writeClassDesc(OutputStream os, Class clz) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeClassDesc( " + os + ", " + clz + " )");
        }
        os.write_value((Serializable)((Object)Util.getCodebase((Class)clz)), (BoxedValueHelper)s_string_helper);
        os.write_value((Serializable)((Object)this.getRMIRepositoryID(clz)), (BoxedValueHelper)s_string_helper);
    }

    private Class readClassDesc(InputStream is) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("readClassDesc( " + is + " )");
        }
        String codebase = (String)((Object)is.read_value((BoxedValueHelper)s_string_helper));
        String repoID = (String)((Object)is.read_value((BoxedValueHelper)s_string_helper));
        if (repoID.equals(WStringValueHelper.id())) {
            return class$java$lang$String == null ? (class$java$lang$String = ValueHandlerImpl.class$("java.lang.String")) : class$java$lang$String;
        }
        if (repoID.startsWith("RMI:javax.rmi.CORBA.ClassDesc:")) {
            return class$java$lang$Class == null ? (class$java$lang$Class = ValueHandlerImpl.class$("java.lang.Class")) : class$java$lang$Class;
        }
        String clzName = RepoIDHelper.unmangleRepoIDtoClassName((String)repoID);
        if (clzName == null) {
            throw new MARSHAL("Could not find classname from repository ID: \"" + repoID + "\"");
        }
        try {
            return Util.loadClass((String)clzName, (String)codebase, (ClassLoader)null);
        }
        catch (ClassNotFoundException ex) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Couldn't find class " + clzName + ".", (Throwable)ex);
            }
            throw new MARSHAL("Couldn't find class " + clzName + " (" + ex + ")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(OutputStream os, Serializable value) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeArray( " + os + ", " + value + " )");
        }
        int len = Array.getLength(value);
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("writeArray: writing array length = " + len);
        }
        os.write_long(len);
        if (len == 0) {
            return;
        }
        Class<?> cmpt = value.getClass().getComponentType();
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("writeArray: writing array of type '" + cmpt.getName() + "'");
        }
        if (cmpt.isPrimitive()) {
            if (cmpt.equals(Boolean.TYPE)) {
                os.write_boolean_array((boolean[])value, 0, len);
                return;
            } else if (cmpt.equals(Byte.TYPE)) {
                os.write_octet_array((byte[])value, 0, len);
                return;
            } else if (cmpt.equals(Short.TYPE)) {
                os.write_short_array((short[])value, 0, len);
                return;
            } else if (cmpt.equals(Integer.TYPE)) {
                os.write_long_array((int[])value, 0, len);
                return;
            } else if (cmpt.equals(Long.TYPE)) {
                os.write_longlong_array((long[])value, 0, len);
                return;
            } else if (cmpt.equals(Float.TYPE)) {
                os.write_float_array((float[])value, 0, len);
                return;
            } else if (cmpt.equals(Double.TYPE)) {
                os.write_double_array((double[])value, 0, len);
                return;
            } else {
                if (!cmpt.equals(Character.TYPE)) throw new Error("Unknown primtive type");
                os.write_wchar_array((char[])value, 0, len);
            }
            return;
        } else {
            Object[] arr = (Object[])value;
            int i = 0;
            while (i < len) {
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("writeArray: array[ " + i + " ] = " + arr[i]);
                }
                this.writeStreamValue(os, cmpt, arr[i]);
                ++i;
            }
        }
    }

    private Serializable readArray(InputStream is, int offset, Class clz) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("readArray( " + is + ", " + offset + ", " + clz + " )");
        }
        int len = is.read_long();
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("writeArray: reading array of length = " + len);
        }
        Class<?> cmpt = clz.getComponentType();
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("writeArray: reading array of type '" + cmpt.getName() + "'");
        }
        if (cmpt.isPrimitive()) {
            if (cmpt.equals(Boolean.TYPE)) {
                boolean[] value = new boolean[len];
                is.read_boolean_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Byte.TYPE)) {
                byte[] value = new byte[len];
                is.read_octet_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Short.TYPE)) {
                short[] value = new short[len];
                is.read_short_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Integer.TYPE)) {
                int[] value = new int[len];
                is.read_long_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Long.TYPE)) {
                long[] value = new long[len];
                is.read_longlong_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Float.TYPE)) {
                float[] value = new float[len];
                is.read_float_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Double.TYPE)) {
                double[] value = new double[len];
                is.read_double_array(value, 0, len);
                return value;
            }
            if (cmpt.equals(Character.TYPE)) {
                char[] value = new char[len];
                is.read_wchar_array(value, 0, len);
                return value;
            }
            throw new Error("Unknown primitive type");
        }
        Object[] value = (Object[])Array.newInstance(cmpt, len);
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug("writeArray: array of type '" + cmpt.getName() + "' to be read");
        }
        boolean doPop = this.addReadIndirect(is, offset, (Serializable)value);
        int i = 0;
        while (i < len) {
            Object obj = this.readStreamValue(is, cmpt);
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("writeArray: array[ " + i + " ] = " + obj);
            }
            value[i] = obj;
            ++i;
        }
        if (doPop) {
            this.popReadIndirect();
        }
        return value;
    }

    private void writeStreamValue(OutputStream os, Class decl, Object value) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("writeStreamValue( " + os + ", " + decl + ", " + value + " )");
        }
        if (decl.isArray()) {
            os.write_value((Serializable)value);
        } else {
            Object obj = value;
            if (!(class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(decl) && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(decl) && obj != null) {
                obj = UtilDelegateImpl.exportRemote((org.omg.CORBA.portable.OutputStream)os, (Remote)value);
            }
            os.write_abstract_interface(obj);
        }
    }

    private Object readStreamValue(InputStream is, Class decl) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("readStreamValue( " + is + ", " + decl + " )");
        }
        if (decl.isArray()) {
            return is.read_value(decl);
        }
        Object obj = is.read_abstract_interface(decl);
        if (obj != null && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(decl)) {
            return PortableRemoteObjectDelegateImpl.narrowExt(obj, decl, false);
        }
        return obj;
    }

    private Serializable checkReadIndirect(int offset) {
        ReadIndirectTable tbl;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("checkReadIndirect( " + offset + " )");
        }
        if ((tbl = (ReadIndirectTable)s_ri_local.get()) != null) {
            return (Serializable)tbl.getMap().get(NumberCache.getInteger((int)offset));
        }
        return null;
    }

    private boolean addReadIndirect(InputStream in, int offset, Serializable value) {
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("addReadIndirect( " + in + ", " + offset + ", <value not yet deserialized> )");
        }
        if (in instanceof CDRInputStream) {
            ((CDRInputStream)in).addIndirect(offset, value);
            return false;
        }
        ReadIndirectTable tbl = (ReadIndirectTable)s_ri_local.get();
        if (tbl == null) {
            tbl = new ReadIndirectTable();
            s_ri_local.set(tbl);
        }
        tbl.incLevel();
        tbl.getMap().put(NumberCache.getInteger((int)offset), value);
        return true;
    }

    private void popReadIndirect() {
        ReadIndirectTable tbl;
        if (this.getLogger().isDebugEnabled() && Trace.isLow()) {
            this.getLogger().debug("popReadIndirect()");
        }
        if ((tbl = (ReadIndirectTable)s_ri_local.get()).decLevel() == 0) {
            tbl.getMap().clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_kernel = DeserializationKernelFactory.retrieveDeserializationKernel();
        s_string_helper = new WStringValueHelper();
        s_ri_local = new ThreadLocal();
    }

    private class GetFieldImpl
    extends ObjectInputStream.GetField {
        private final Map m_field_values = new HashMap();
        private final RMIObjectStreamClass m_object_stream_class;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GetFieldImpl(RMIObjectStreamClass osc, InputStream is) {
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isLow()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl( " + osc + ", " + is + " )");
            }
            this.m_object_stream_class = osc;
            ObjectStreamField[] fields = this.m_object_stream_class.getObjectStreamFields();
            try {
                int i = 0;
                while (i < fields.length) {
                    Class<?> ft = fields[i].getType();
                    if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        ValueHandlerImpl.super.getLogger().debug("GetFieldImpl: field[ " + i + " ] = " + fields[i].getName() + ", type=" + ft.getName());
                    }
                    if (ft.isPrimitive()) {
                        if (ft.equals(Boolean.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), is.read_boolean() ? Boolean.TRUE : Boolean.FALSE);
                        } else if (ft.equals(Byte.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getByte((byte)is.read_octet()));
                        } else if (ft.equals(Short.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getShort((short)is.read_short()));
                        } else if (ft.equals(Integer.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getInteger((int)is.read_long()));
                        } else if (ft.equals(Long.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getLong((long)is.read_longlong()));
                        } else if (ft.equals(Float.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getFloat((float)is.read_float()));
                        } else if (ft.equals(Double.TYPE)) {
                            this.m_field_values.put(fields[i].getName(), NumberCache.getDouble((double)is.read_double()));
                        } else {
                            if (!ft.equals(Character.TYPE)) throw new Error("Unknown primitive type");
                            this.m_field_values.put(fields[i].getName(), CharacterCache.getCharacter((char)is.read_wchar()));
                        }
                    } else {
                        this.m_field_values.put(fields[i].getName(), ValueHandlerImpl.this.readStreamValue(is, ft));
                    }
                    ++i;
                }
                return;
            }
            catch (IllegalArgumentException ex) {
                if (ValueHandlerImpl.super.getLogger() == null || !ValueHandlerImpl.super.getLogger().isErrorEnabled()) throw new Error("Illegal argument exception (" + ex + ")");
                ValueHandlerImpl.super.getLogger().error("Illegal argument exception.", (Throwable)ex);
                throw new Error("Illegal argument exception (" + ex + ")");
            }
            catch (Exception ex) {
                if (ValueHandlerImpl.super.getLogger() == null || !ValueHandlerImpl.super.getLogger().isErrorEnabled()) throw new Error("Unknown exception (" + ex + ")");
                ValueHandlerImpl.super.getLogger().error("Unknown exception!", (Throwable)ex);
                throw new Error("Unknown exception (" + ex + ")");
            }
        }

        private void checkFieldName(String name) {
            if (!this.m_field_values.containsKey(name)) {
                throw new IllegalArgumentException("Field " + name + " is not a serial field.");
            }
        }

        public boolean defaulted(String str) throws IllegalArgumentException {
            this.checkFieldName(str);
            return false;
        }

        public boolean get(String str, boolean param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Boolean)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Boolean");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Boolean)val;
        }

        public byte get(String str, byte param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Byte)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Byte");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Byte)val;
        }

        public short get(String str, short param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Short)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Short");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Short)val;
        }

        public int get(String str, int param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Integer)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Integer");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Integer)val;
        }

        public long get(String str, long param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Long)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Long");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Long)val;
        }

        public float get(String str, float param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Float)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Float");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return ((Float)val).floatValue();
        }

        public double get(String str, double param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Double)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Double");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return (Double)val;
        }

        public char get(String str, char param) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (!(val instanceof Character)) {
                throw new IllegalArgumentException("Value " + val + " is not of type Character");
            }
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return ((Character)val).charValue();
        }

        public Object get(String str, Object obj) throws IllegalArgumentException {
            this.checkFieldName(str);
            Object val = this.m_field_values.get(str);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("GetFieldImpl.get( " + str + ", " + val + " )");
            }
            return val;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return this.m_object_stream_class.getObjectStreamClass();
        }
    }

    private class PutFieldImpl
    extends ObjectOutputStream.PutField {
        private final Map m_field_values = new HashMap();
        private final Map m_fields = new HashMap();
        private final RMIObjectStreamClass m_object_stream_class;

        PutFieldImpl(Serializable value, RMIObjectStreamClass osc) {
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isLow()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl( " + value + ", " + osc + " )");
            }
            this.m_object_stream_class = osc;
            ObjectStreamField[] fields = osc.getObjectStreamFields();
            int i = 0;
            while (i < fields.length) {
                if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    ValueHandlerImpl.super.getLogger().debug("PutFieldImpl: fields[ " + i + " ] = " + fields[i].getName());
                }
                this.m_fields.put(fields[i].getName(), fields[i]);
                ++i;
            }
        }

        private void checkFieldName(String name) {
            if (!this.m_fields.containsKey(name)) {
                throw new IllegalArgumentException("Field " + name + " is not a serial field");
            }
        }

        public void put(String name, boolean val) throws IllegalArgumentException {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, val ? Boolean.TRUE : Boolean.FALSE);
        }

        public void put(String name, byte val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getByte((byte)val));
        }

        public void put(String name, char val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, CharacterCache.getCharacter((char)val));
        }

        public void put(String name, double val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getDouble((double)val));
        }

        public void put(String name, float val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getFloat((float)val));
        }

        public void put(String name, int val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getInteger((int)val));
        }

        public void put(String name, long val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getLong((long)val));
        }

        public void put(String name, Object val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, val);
        }

        public void put(String name, short val) {
            this.checkFieldName(name);
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.put( " + name + ", " + val + " )");
            }
            this.m_field_values.put(name, NumberCache.getShort((short)val));
        }

        public void write(ObjectOutput out) {
            throw new Error("Not implemented!");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(OutputStream os) {
            if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isLow()) {
                ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.write( " + os + " )");
            }
            ObjectStreamField[] fields = this.m_object_stream_class.getObjectStreamFields();
            int i = 0;
            while (i < fields.length) {
                ObjectStreamField field = fields[i];
                String fldname = field.getName();
                Object val = this.m_field_values.get(fldname);
                if (ValueHandlerImpl.super.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    ValueHandlerImpl.super.getLogger().debug("PutFieldImpl.write: fields[" + i + "].getName()=" + fldname + ", value=" + val);
                }
                if (val != null) {
                    Class<?> ft = field.getType();
                    if (ft.isPrimitive()) {
                        if (ft.equals(Boolean.TYPE)) {
                            os.write_boolean(((Boolean)val).booleanValue());
                        } else if (ft.equals(Byte.TYPE)) {
                            os.write_octet(((Byte)val).byteValue());
                        } else if (ft.equals(Short.TYPE)) {
                            os.write_short(((Short)val).shortValue());
                        } else if (ft.equals(Integer.TYPE)) {
                            os.write_long(((Integer)val).intValue());
                        } else if (ft.equals(Long.TYPE)) {
                            os.write_longlong(((Long)val).longValue());
                        } else if (ft.equals(Float.TYPE)) {
                            os.write_float(((Float)val).floatValue());
                        } else if (ft.equals(Double.TYPE)) {
                            os.write_double(((Double)val).doubleValue());
                        } else {
                            if (!ft.equals(Character.TYPE)) throw new Error("Unknown primitive type");
                            os.write_wchar(((Character)val).charValue());
                        }
                    } else {
                        ValueHandlerImpl.this.writeStreamValue(os, ft, val);
                    }
                }
                ++i;
            }
        }
    }

    private static class ReadIndirectTable {
        private int m_level;
        private Map m_map = new HashMap();

        public ReadIndirectTable() {
            this.m_level = 0;
            this.m_map = new HashMap();
        }

        public ReadIndirectTable(int level, HashMap map) {
            this.m_level = level;
            this.m_map = map;
        }

        public int getLevel() {
            return this.m_level;
        }

        public void setLevel(int level) {
            this.m_level = level;
        }

        public int incLevel() {
            ++this.m_level;
            return this.m_level;
        }

        public int decLevel() {
            --this.m_level;
            return this.m_level;
        }

        public Map getMap() {
            return this.m_map;
        }

        public void setMap(HashMap map) {
            this.m_map = map;
        }
    }
}

