/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openorb.util.HexPrintStream;

public class DebugSocketInputStream
extends InputStream {
    private static final SimpleDateFormat FILE_SDF = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final InputStream m_parent;
    private final OutputStream m_fileStream;
    private final PrintWriter m_printWriter;
    private final HexPrintStream m_hexStream;

    public DebugSocketInputStream(InputStream parent, long timestamp, String description) throws IOException {
        this.m_parent = parent;
        File dir = DebugSocketInputStream.getDirectory(timestamp);
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new IOException("Couldn't create temporary folder: " + dir);
        }
        File file = DebugSocketInputStream.getFile(dir, description);
        this.m_fileStream = new FileOutputStream(file);
        this.m_printWriter = new PrintWriter(this.m_fileStream, true);
        this.m_hexStream = new HexPrintStream(this.m_fileStream, 2);
        this.m_printWriter.println("Type   : DebugSocketInputStream");
        this.m_printWriter.print("Socket : ");
        this.m_printWriter.println(description);
        this.m_printWriter.print("Created: ");
        this.m_printWriter.println(SDF.format(new Date(System.currentTimeMillis())));
        this.m_printWriter.print("Thread : ");
        this.m_printWriter.println(Thread.currentThread());
        this.m_printWriter.println();
    }

    private static File getDirectory(long timestamp) throws IOException {
        File javaIOTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File userTmpDir = new File(javaIOTmpDir, System.getProperty("user.name"));
        File timestampDir = new File(userTmpDir, FILE_SDF.format(new Date(timestamp)));
        return new File(timestampDir, "input");
    }

    private static File getFile(File directory, String description) {
        return new File(directory, "socket." + description + ".[" + FILE_SDF.format(new Date(System.currentTimeMillis())) + "].log");
    }

    private void printHeading() {
        this.m_printWriter.println();
        this.m_printWriter.println("---------------------------------------------------------");
        this.m_printWriter.print("Thread : ");
        this.m_printWriter.println(Thread.currentThread());
        this.m_printWriter.print("Time   : ");
        this.m_printWriter.println(SDF.format(new Date(System.currentTimeMillis())));
    }

    public int read() throws IOException {
        int b = this.m_parent.read();
        this.printHeading();
        this.m_printWriter.print("Data   : 1 Byte read, ");
        this.m_printWriter.print(b);
        this.m_printWriter.print(" '");
        this.m_printWriter.print((char)b);
        this.m_printWriter.print("' 0x");
        this.m_printWriter.println(Integer.toHexString(b));
        return b;
    }

    public int read(byte[] buf) throws IOException {
        int result = this.m_parent.read(buf);
        this.printHeading();
        this.m_printWriter.print("Data   : ");
        this.m_printWriter.print(result);
        this.m_printWriter.print(" Bytes read, buf.length=");
        this.m_printWriter.println(buf.length);
        this.m_hexStream.write(buf);
        this.m_hexStream.flush();
        return result;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int result = this.m_parent.read(buf, off, len);
        this.printHeading();
        this.m_printWriter.print("Data   : ");
        this.m_printWriter.print(result);
        this.m_printWriter.print(" Bytes read, buf.length=");
        this.m_printWriter.print(buf.length);
        this.m_printWriter.print(", off=");
        this.m_printWriter.print(off);
        this.m_printWriter.print(", len=");
        this.m_printWriter.println(len);
        this.m_hexStream.write(buf, off, len);
        this.m_hexStream.flush();
        return result;
    }

    public void close() throws IOException {
        this.m_parent.close();
        this.printHeading();
        this.m_printWriter.println("Closing InputStream");
        this.m_hexStream.close();
        this.m_printWriter.close();
        this.m_fileStream.close();
    }
}

