/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openorb.util.HexPrintStream;

public class DebugSocketOutputStream
extends OutputStream {
    private static final SimpleDateFormat FILE_SDF = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS");
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final OutputStream m_parent;
    private final FileOutputStream m_fileStream;
    private final PrintWriter m_printWriter;
    private final HexPrintStream m_hexStream;

    public DebugSocketOutputStream(OutputStream parent, long timestamp, String description) throws IOException {
        this.m_parent = parent;
        File dir = DebugSocketOutputStream.getDirectory(timestamp);
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new IOException("Couldn't create temporary folder: " + dir);
        }
        File file = DebugSocketOutputStream.getFile(dir, description);
        this.m_fileStream = new FileOutputStream(file);
        this.m_printWriter = new PrintWriter(this.m_fileStream, true);
        this.m_hexStream = new HexPrintStream((OutputStream)this.m_fileStream, 2);
        this.m_printWriter.println("Type   : DebugSocketOutputStream");
        this.m_printWriter.print("Socket : ");
        this.m_printWriter.println(description);
        this.m_printWriter.print("Created: ");
        this.m_printWriter.println(SDF.format(new Date(System.currentTimeMillis())));
        this.m_printWriter.print("Thread : ");
        this.m_printWriter.println(Thread.currentThread());
        this.m_printWriter.println();
    }

    private static File getDirectory(long timestamp) {
        File javaIOTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File userTmpDir = new File(javaIOTmpDir, System.getProperty("user.name"));
        File timestampDir = new File(userTmpDir, FILE_SDF.format(new Date(timestamp)));
        return new File(timestampDir, "output");
    }

    private static File getFile(File directory, String description) {
        return new File(directory, "socket." + description + ".[" + FILE_SDF.format(new Date(System.currentTimeMillis())) + "].log");
    }

    private void printHeading() {
        this.m_printWriter.println();
        this.m_printWriter.println("---------------------------------------------------------");
        this.m_printWriter.print("Thread : ");
        this.m_printWriter.println(Thread.currentThread());
        this.m_printWriter.print("Time   : ");
        this.m_printWriter.println(SDF.format(new Date(System.currentTimeMillis())));
    }

    public void write(int b) throws IOException {
        this.m_parent.write(b);
        this.printHeading();
        this.m_printWriter.print("Data   : 1 Byte written, ");
        this.m_printWriter.print(b);
        this.m_printWriter.print(" '");
        this.m_printWriter.print((char)b);
        this.m_printWriter.print("' 0x");
        this.m_printWriter.println(Integer.toHexString(b));
    }

    public void write(byte[] buf) throws IOException {
        this.m_parent.write(buf);
        this.printHeading();
        this.m_printWriter.print("Data   : ");
        this.m_printWriter.print(buf.length);
        this.m_printWriter.print(" Bytes written, buf.length=");
        this.m_printWriter.println(buf.length);
        this.m_hexStream.write(buf);
        this.m_hexStream.flush();
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.m_parent.write(buf, off, len);
        this.printHeading();
        this.m_printWriter.print("Data   : ");
        this.m_printWriter.print(len);
        this.m_printWriter.print(" Bytes written, buf.length=");
        this.m_printWriter.print(buf.length);
        this.m_printWriter.print(", off=");
        this.m_printWriter.print(off);
        this.m_printWriter.print(", len=");
        this.m_printWriter.println(len);
        this.m_hexStream.write(buf, off, len);
        this.m_hexStream.flush();
    }

    public void close() throws IOException {
        this.m_parent.close();
        this.printHeading();
        this.m_printWriter.println("Closing OutputStream");
        this.m_hexStream.close();
        this.m_printWriter.close();
        this.m_fileStream.close();
    }

    public void flush() throws IOException {
        this.m_parent.flush();
        this.printHeading();
        this.m_printWriter.println("Flushing OutputStream");
        this.m_printWriter.println("#########################################################");
        this.m_printWriter.flush();
    }
}

