/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.util;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;
import org.openorb.orb.io.StorageBuffer;
import org.openorb.util.HexPrintStream;
import org.openorb.util.logger.ControllableLogger;

public final class Trace {
    public static final ControllableLogger.Control LOGGER_CONTROL = new LoggerControl();
    private static final Object LOGGER_SYNC = new byte[0];
    private static final String DEFAULT_FORMAT = "[%{thread}] [%5.5{priority}] (%{category}): %{message}\\n%{throwable}";
    private static final String DEFAULT_ASSERTION_LOGGER_NAME = "default-assertion-logger";
    public static final int OFF = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "LOW", "MEDIUM", "HIGH"};
    private static volatile int s_level = 0;
    private static OutputStream s_os = System.out;
    private static Hierarchy s_hierarchy;
    private static StreamTarget s_target;
    private static Logger s_logger;

    private Trace() {
    }

    public static Logger getLogger() {
        return Trace.getLogger(null);
    }

    public static Logger getLogger(Properties props) {
        Object object = LOGGER_SYNC;
        synchronized (object) {
            if (null == s_logger) {
                String strPriority = null;
                if (props != null) {
                    strPriority = (String)((Hashtable)props).get("openorb.debug.trace");
                }
                if (strPriority == null) {
                    strPriority = System.getProperty("openorb.debug.trace");
                }
                Priority priority = Trace.getPriorityFromName(strPriority == null ? "ERROR" : strPriority);
                s_logger = Trace.createLogger(priority);
            }
            Logger logger = s_logger;
            return logger;
        }
    }

    public static void setLoggerOutputStream(OutputStream os) {
        s_os = os;
    }

    private static Logger createLogger(Priority priority) {
        s_hierarchy = Hierarchy.getDefaultHierarchy();
        s_target = new StreamTarget(s_os, (Formatter)new ExtendedPatternFormatter(DEFAULT_FORMAT));
        s_hierarchy.setDefaultPriority(priority);
        s_hierarchy.setDefaultLogTarget((LogTarget)s_target);
        return new LogKitLogger(s_hierarchy.getLoggerFor("orb"));
    }

    public static Logger getNewLogger(Priority priority) {
        s_logger = Trace.createLogger(priority);
        return s_logger;
    }

    public static void setLogger(Logger logger) {
        Object object = LOGGER_SYNC;
        synchronized (object) {
            s_logger = logger;
        }
    }

    public static Priority getPriorityFromName(String priority) {
        if (priority == null) {
            return Priority.FATAL_ERROR;
        }
        if (priority.compareToIgnoreCase("FATAL") == 0 || priority.equals("0")) {
            return Priority.FATAL_ERROR;
        }
        if (priority.compareToIgnoreCase("ERROR") == 0 || priority.equals("1")) {
            return Priority.ERROR;
        }
        if (priority.compareToIgnoreCase("WARN") == 0 || priority.equals("2")) {
            return Priority.WARN;
        }
        if (priority.compareToIgnoreCase("INFO") == 0 || priority.equals("3")) {
            return Priority.INFO;
        }
        if (priority.compareToIgnoreCase("DEBUG") == 0 || priority.equals("4")) {
            return Priority.DEBUG;
        }
        return Priority.FATAL_ERROR;
    }

    public static int getDebugLevelFromName(String level) {
        if (level == null) {
            return 0;
        }
        if (level.compareToIgnoreCase("OFF") == 0 || level.equals("0")) {
            return 0;
        }
        if (level.compareToIgnoreCase("LOW") == 0 || level.equals("1")) {
            return 1;
        }
        if (level.compareToIgnoreCase("MEDIUM") == 0 || level.equals("2")) {
            return 2;
        }
        if (level.compareToIgnoreCase("HIGH") == 0 || level.equals("3")) {
            return 3;
        }
        return 0;
    }

    public static void setDebugLevel(int newLevel) {
        s_level = newLevel;
    }

    public static int getDebugLevel() {
        return s_level;
    }

    public static String getNameOfDebugLevel(int level) {
        if (level < 0 || LEVEL_NAMES.length <= level) {
            return "UNKNOWN";
        }
        return LEVEL_NAMES[level];
    }

    public static boolean isEnabled(int value) {
        return s_level <= value;
    }

    public static boolean isLow() {
        return s_level >= 1;
    }

    public static boolean isMedium() {
        return s_level >= 2;
    }

    public static boolean isHigh() {
        return s_level >= 3;
    }

    public static String bufferToString(String msg, byte[] buffer) {
        StringBuffer out = new StringBuffer();
        if (buffer != null && buffer.length > 0) {
            int buflen = buffer.length;
            out.append("\n------------------------------------------------------\n");
            out.append("( " + msg + " ) Displaying a buffer, size = " + buffer.length + "\n");
            out.append("------------------------------------------------------\n");
            int i = 0;
            while (i < buflen) {
                int j = i;
                while (j < i + 16 && j < buflen) {
                    if (Character.isISOControl((char)(buffer[j] & 0x7F))) {
                        out.append('.');
                    } else {
                        out.append((char)buffer[j]);
                    }
                    if (j == i + 7) {
                        out.append(' ');
                    }
                    ++j;
                }
                if (i + 16 > buflen) {
                    int rest = 16 - buflen % 16;
                    int j2 = 0;
                    while (j2 < rest) {
                        out.append(' ');
                        ++j2;
                    }
                    if (rest >= 8) {
                        out.append(' ');
                    }
                }
                out.append(' ');
                out.append(' ');
                int j3 = i;
                while (j3 < i + 16 && j3 < buflen) {
                    out.append(HexPrintStream.toHex((byte)buffer[j3]));
                    if (j3 == i + 3 || j3 == i + 7 || j3 == i + 11) {
                        out.append(' ');
                    }
                    ++j3;
                }
                out.append("\n");
                i += 16;
            }
            out.append("------------------------------------------------------\n");
        }
        return out.toString();
    }

    public static String bufferToString(String msg, StorageBuffer buf) {
        return Trace.bufferToString(msg, buf.linearize());
    }

    public static Error signalIllegalCondition(Logger optionalLogger, String message) {
        Logger logger = null == optionalLogger ? Trace.getAssertionLogger() : optionalLogger;
        IllegalConditionError e = new IllegalConditionError(message);
        logger.fatalError("IllegalCondition [" + message + "]", (Throwable)e);
        throw e;
    }

    public static boolean isGIOPHeaderOK(byte[] buf, int off) {
        boolean result = true;
        if (buf[off + 0] != 71 || buf[off + 1] != 73 || buf[off + 2] != 79 || buf[off + 3] != 80 || buf[off + 4] != 1 || buf[off + 5] > 2) {
            System.err.println("###############################################");
            System.err.println("!!Trying to send/receive corrupt GIOP message!!");
            System.err.println("###############################################");
            Thread.dumpStack();
            System.err.println("###############################################");
            System.err.println(Trace.bufferToString("The corrupted buffer (off=" + off + ")", buf));
            System.err.println("###############################################");
            result = false;
        }
        return result;
    }

    private static Logger getAssertionLogger() {
        return Trace.getLogger().getChildLogger(DEFAULT_ASSERTION_LOGGER_NAME);
    }

    private static final class LoggerControl
    implements ControllableLogger.Control {
        public boolean isDebugEnabled() {
            return Trace.isHigh();
        }

        public boolean isInfoEnabled() {
            return Trace.isHigh();
        }

        public boolean isWarnEnabled() {
            return Trace.isMedium();
        }

        public boolean isErrorEnabled() {
            return Trace.isLow();
        }

        public boolean isFatalErrorEnabled() {
            return Trace.isLow();
        }
    }

    public static class StackSnapshot
    extends Throwable {
        public StackSnapshot() {
            super("## Debug information - not error ##");
        }
    }

    public static class IllegalConditionError
    extends Error {
        public IllegalConditionError(String message) {
            super(message);
        }
    }
}

