/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.subtrx;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.openorb.ots.examples.subtrx.Account;
import org.openorb.ots.examples.subtrx.Bank;
import org.openorb.ots.examples.subtrx.BankHelper;
import org.openorb.ots.examples.subtrx.NotExistingAccount;

public final class BankClient {
    private Bank m_bank;
    private ORB m_orb;

    private BankClient(Bank bank, ORB orb) {
        this.m_bank = bank;
        this.m_orb = orb;
    }

    private int menu() {
        int result = -1;
        do {
            System.out.println("");
            System.out.println("-------------------------------------------------");
            System.out.println("Bank client ");
            System.out.println("-------------------------------------------------");
            System.out.println("");
            System.out.println("Select an option : ");
            System.out.println("\t0. Quit");
            System.out.println("\t1. Create a new account.");
            System.out.println("\t2. Get an account information.");
            System.out.println("\t3. Make a transfer.");
            System.out.println("");
            System.out.print("Your choice : ");
            String choice = this.input();
            try {
                result = new Integer(choice);
            }
            catch (Exception ex) {
                result = -1;
            }
        } while (result == -1);
        return result;
    }

    private String input() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void begin() {
        while (true) {
            switch (this.menu()) {
                case 0: {
                    System.exit(0);
                }
                case 1: {
                    this.newAccount();
                    break;
                }
                case 2: {
                    this.getInfo();
                    break;
                }
                case 3: {
                    this.makeTransfer();
                }
            }
        }
    }

    private void newAccount() {
        System.out.println("");
        System.out.println("- Create a new account -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        if (name == null) {
            System.out.println("Abort operation...");
            return;
        }
        System.out.print("Initial balance : ");
        String balance = this.input();
        if (balance == null) {
            System.out.println("Abort operation...");
            return;
        }
        float fbalance = 0.0f;
        try {
            fbalance = new Float(balance).floatValue();
        }
        catch (Exception ex) {
            System.out.println("Invalid float number, abort operation...");
            return;
        }
        try {
            Current current = null;
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            current = CurrentHelper.narrow(obj);
            current.begin();
            Account acc = this.m_bank.create_account(name);
            acc.credit(fbalance);
            current.commit(false);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            System.out.println("Transaction rolled back !");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getInfo() {
        System.out.println("");
        System.out.println("- Get information about an account -");
        System.out.println("------------------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        if (name == null) {
            System.out.println("Abort operation...");
            return;
        }
        try {
            Current current = null;
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            current = CurrentHelper.narrow(obj);
            current.begin();
            Account acc = this.m_bank.get_account(name);
            System.out.println("Balance : " + acc.balance());
            current.commit(false);
        }
        catch (NotExistingAccount ex) {
            System.out.println("Account not existing !");
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            System.out.println("Transaction rolled back !");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void makeTransfer() {
        System.out.println("");
        System.out.println("- Make a transfer -");
        System.out.println("-------------------");
        System.out.println("");
        System.out.print("Take money from : ");
        String name_supplier = this.input();
        if (name_supplier == null) {
            System.out.println("Abort operation...");
            return;
        }
        System.out.print("Put money to : ");
        String name_consumer = this.input();
        if (name_consumer == null) {
            System.out.println("Abort operation...");
            return;
        }
        System.out.print("Transfert amount : ");
        String amount = this.input();
        if (amount == null) {
            System.out.println("Abort operation...");
            return;
        }
        float famount = 0.0f;
        try {
            famount = new Float(amount).floatValue();
        }
        catch (Exception ex) {
            System.out.println("Invalid float number, abort operation...");
            return;
        }
        try {
            boolean commit;
            Current current;
            block22: {
                current = null;
                Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
                current = CurrentHelper.narrow(obj);
                commit = true;
                current.begin();
                Account supplier = null;
                try {
                    current.begin();
                    supplier = this.m_bank.get_account(name_supplier);
                    supplier.debit(famount);
                    current.commit(true);
                }
                catch (TRANSACTION_ROLLEDBACK ex) {
                    System.out.println("Such a debit is not possible...");
                    try {
                        current.begin();
                        supplier.credit(famount);
                        current.commit(true);
                    }
                    catch (TRANSACTION_ROLLEDBACK subex) {
                        commit = false;
                    }
                    if (!commit) break block22;
                    System.out.println("Last chance, please enter the debit amount : ");
                    amount = this.input();
                    if (amount == null) {
                        System.out.println("Abort operation...");
                        return;
                    }
                    try {
                        famount = new Float(amount).floatValue();
                    }
                    catch (Exception subex) {
                        System.out.println("Invalid float number, abort operation...");
                        return;
                    }
                    System.out.println("Retry...");
                    try {
                        current.begin();
                        supplier.debit(famount);
                        current.commit(true);
                    }
                    catch (TRANSACTION_ROLLEDBACK subex) {
                        System.out.println("Debit not authorized...");
                        commit = false;
                    }
                }
            }
            if (commit) {
                try {
                    current.begin();
                    Account consumer = this.m_bank.get_account(name_consumer);
                    consumer.credit(famount);
                    current.commit(true);
                }
                catch (TRANSACTION_ROLLEDBACK ex) {
                    System.out.println("Credit not authorized...");
                    commit = false;
                }
            }
            if (commit) {
                current.commit(true);
            } else {
                current.rollback();
                System.out.println("Transfer canceled !");
            }
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            System.out.println("Transaction rolled back !");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        ((Hashtable)props).put("openorb.profile", "ots");
        ORB orb = ORB.init((String[])args, (Properties)props);
        Object obj = null;
        try {
            FileInputStream file = new FileInputStream("ObjectId");
            InputStreamReader input = new InputStreamReader(file);
            BufferedReader reader = new BufferedReader(input);
            String stringTarget = reader.readLine();
            obj = orb.string_to_object(stringTarget);
        }
        catch (IOException ex) {
            System.out.println("File error");
            System.exit(0);
        }
        Bank bank = BankHelper.narrow(obj);
        BankClient client = new BankClient(bank, orb);
        client.begin();
    }
}

