/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.withoutres;

import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.NoTransaction;
import org.openorb.ots.examples.withoutres.AccountPOA;

public class AccountImpl
extends AccountPOA {
    private float m_balance = 0.0f;
    private ORB m_orb;
    private String m_name;

    public AccountImpl(ORB orb, String name) {
        this.m_orb = orb;
        this.m_name = name;
    }

    public float balance() {
        return this.m_balance;
    }

    public void credit(float value) {
        if (value < 0.0f) {
            this.rollbackOnly();
        } else {
            this.m_balance += value;
        }
    }

    public void debit(float value) {
        if (this.m_balance - value < 0.0f) {
            this.rollbackOnly();
        } else {
            this.m_balance -= value;
        }
    }

    public void rollbackOnly() {
        try {
            Object obj = this.m_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow(obj);
            current.rollback_only();
        }
        catch (InvalidName ex) {
            throw new TRANSACTION_REQUIRED();
        }
        catch (NoTransaction ex) {
            throw new TRANSACTION_REQUIRED();
        }
    }
}

