/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.examples.withres;

import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.examples.withres.AccountImpl;
import org.openorb.ots.examples.withres.AccountResourcePOA;

public class AccountResourceImpl
extends AccountResourcePOA {
    private float m_initial_balance;
    private float m_current_balance;
    private Coordinator m_coordinator;
    private AccountImpl m_account;
    private String m_name;
    private POA m_poa;

    public AccountResourceImpl(POA poa, Coordinator coordinator, AccountImpl account, float initial_balance, String name) {
        this.m_coordinator = coordinator;
        this.m_name = name;
        this.m_poa = poa;
        this.m_account = account;
        this.m_current_balance = this.m_initial_balance = initial_balance;
    }

    public float balance() {
        return this.m_current_balance;
    }

    public void credit(float value) {
        this.m_current_balance += value;
    }

    public void debit(float value) {
        this.m_current_balance -= value;
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        System.out.println("[ Resource for " + this.m_name + " : Prepare ]");
        if (this.m_initial_balance == this.m_current_balance) {
            this.removeItself();
            return Vote.VoteReadOnly;
        }
        if (this.m_current_balance < 0.0f) {
            this.removeItself();
            return Vote.VoteRollback;
        }
        return Vote.VoteCommit;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        System.out.println("[ Resource for " + this.m_name + " : Rollback ]");
        this.removeItself();
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        System.out.println("[ Resource for " + this.m_name + " : Commit ]");
        this.m_account.balance(this.m_current_balance);
        this.removeItself();
    }

    public void commit_one_phase() throws HeuristicHazard {
        System.out.println("[ Resource for " + this.m_name + " : Commit one phase ]");
        this.m_account.balance(this.m_current_balance);
        this.removeItself();
    }

    public void forget() {
        System.out.println("[ Resource for " + this.m_name + " : Forget ]");
        this.removeItself();
    }

    public Coordinator coordinator() {
        return this.m_coordinator;
    }

    private void removeItself() {
        try {
            this.m_account.resources().removeElement(this);
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
        }
        catch (ServantNotActive servantNotActive) {
            // empty catch block
        }
    }
}

