/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.LayoutHandler;
import org.apache.fop.apps.Service;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.apps.Version;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.mif.MIFHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.rtf.renderer.RTFHandler;
import org.apache.fop.tools.DocumentInputSource;
import org.apache.fop.tools.DocumentReader;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Driver
implements LogEnabled {
    public static final int RENDER_PDF = 1;
    public static final int RENDER_AWT = 2;
    public static final int RENDER_MIF = 3;
    public static final int RENDER_XML = 4;
    public static final int RENDER_PRINT = 5;
    public static final int RENDER_PCL = 6;
    public static final int RENDER_PS = 7;
    public static final int RENDER_TXT = 8;
    public static final int RENDER_SVG = 9;
    public static final int RENDER_RTF = 10;
    private FOTreeBuilder treeBuilder;
    private int rendererType;
    private Renderer renderer;
    private StructureHandler structHandler;
    private InputSource source;
    private OutputStream stream = null;
    private XMLReader reader;
    private Logger log = null;
    private FOUserAgent userAgent = null;
    static /* synthetic */ Class class$org$apache$fop$fo$ElementMapping;

    public static final String getParserClassName() {
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader().getClass().getName();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
    }

    public Driver() {
    }

    public Driver(InputSource source, OutputStream stream) {
        this();
        this.source = source;
        this.stream = stream;
    }

    public void initialize() {
        this.stream = null;
        this.treeBuilder = new FOTreeBuilder();
        this.treeBuilder.setUserAgent(this.getUserAgent());
        this.setupDefaultMappings();
    }

    public void setUserAgent(FOUserAgent agent) {
        this.userAgent = agent;
    }

    private FOUserAgent getUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = new FOUserAgent();
            this.userAgent.enableLogging(this.getLogger());
            this.userAgent.setBaseURL("");
        }
        return this.userAgent;
    }

    public void enableLogging(Logger log) {
        if (this.log == null) {
            this.log = log;
        } else {
            this.getLogger().warn("Logger is already set! Won't use the new logger.");
        }
    }

    protected Logger getLogger() {
        if (this.log == null) {
            this.log = new ConsoleLogger(1);
            this.log.error("Logger not set. Using ConsoleLogger as default.");
        }
        return this.log;
    }

    public synchronized void reset() {
        this.source = null;
        this.stream = null;
        this.reader = null;
        this.treeBuilder.reset();
    }

    public boolean hasData() {
        return this.treeBuilder.hasData();
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public void setInputSource(InputSource source) {
        this.source = source;
    }

    public void setXMLReader(XMLReader reader) {
        this.reader = reader;
    }

    public void setupDefaultMappings() {
        this.addElementMapping("org.apache.fop.fo.FOElementMapping");
        this.addElementMapping("org.apache.fop.svg.SVGElementMapping");
        this.addElementMapping("org.apache.fop.extensions.ExtensionElementMapping");
        Iterator providers = Service.providers(class$org$apache$fop$fo$ElementMapping == null ? (class$org$apache$fop$fo$ElementMapping = Driver.class$("org.apache.fop.fo.ElementMapping")) : class$org$apache$fop$fo$ElementMapping);
        if (providers != null) {
            while (providers.hasNext()) {
                String str = (String)providers.next();
                try {
                    this.addElementMapping(str);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warn("Error while adding element mapping", (Throwable)e);
                }
            }
        }
    }

    public void setRenderer(int renderer) throws IllegalArgumentException {
        this.rendererType = renderer;
        switch (renderer) {
            case 1: {
                this.setRenderer("org.apache.fop.render.pdf.PDFRenderer");
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for AWT");
            }
            case 5: {
                throw new IllegalArgumentException("Use renderer form of setRenderer() for PRINT");
            }
            case 6: {
                this.setRenderer("org.apache.fop.render.pcl.PCLRenderer");
                break;
            }
            case 7: {
                this.setRenderer("org.apache.fop.render.ps.PSRenderer");
                break;
            }
            case 8: {
                this.setRenderer("org.apache.fop.render.txt.TXTRenderer()");
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.setRenderer("org.apache.fop.render.xml.XMLRenderer");
                break;
            }
            case 9: {
                this.setRenderer("org.apache.fop.render.svg.SVGRenderer");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown renderer type");
            }
        }
    }

    public void setRenderer(Renderer renderer) {
        renderer.setUserAgent(this.getUserAgent());
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(String rendererClassName, String version) {
        this.setRenderer(rendererClassName);
    }

    public void setRenderer(String rendererClassName) throws IllegalArgumentException {
        try {
            this.renderer = (Renderer)Class.forName(rendererClassName).newInstance();
            if (this.renderer instanceof LogEnabled) {
                ((LogEnabled)this.renderer).enableLogging(this.getLogger());
            }
            this.renderer.setProducer(Version.getVersion());
            this.renderer.setUserAgent(this.getUserAgent());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + rendererClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + rendererClassName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + rendererClassName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(rendererClassName + " is not a renderer");
        }
    }

    public void addElementMapping(ElementMapping mapping) {
        mapping.addToBuilder(this.treeBuilder);
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).newInstance();
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(mappingClassName + " is not an ElementMapping");
        }
    }

    public ContentHandler getContentHandler() {
        if (this.rendererType == 3) {
            this.structHandler = new MIFHandler(this.stream);
        } else if (this.rendererType == 10) {
            this.structHandler = new RTFHandler(this.stream);
        } else {
            if (this.renderer == null) {
                throw new IllegalStateException("Renderer not set when using standard structHandler");
            }
            this.structHandler = new LayoutHandler(this.stream, this.renderer, true);
        }
        this.structHandler.enableLogging(this.getLogger());
        this.treeBuilder.setUserAgent(this.getUserAgent());
        this.treeBuilder.setStructHandler(this.structHandler);
        return this.treeBuilder;
    }

    public synchronized void render(XMLReader parser, InputSource source) throws FOPException {
        parser.setContentHandler(this.getContentHandler());
        try {
            parser.parse(source);
        }
        catch (SAXException e) {
            if (e.getException() instanceof FOPException) {
                throw (FOPException)e.getException();
            }
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public synchronized void render(Document document) throws FOPException {
        try {
            DocumentInputSource source = new DocumentInputSource(document);
            DocumentReader reader = new DocumentReader();
            reader.setContentHandler(this.getContentHandler());
            reader.parse(source);
        }
        catch (SAXException e) {
            if (e.getException() instanceof FOPException) {
                throw (FOPException)e.getException();
            }
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public synchronized void run() throws IOException, FOPException {
        if (this.renderer == null) {
            this.setRenderer(1);
        }
        if (this.source == null) {
            throw new FOPException("InputSource is not set.");
        }
        if (this.reader == null && !(this.source instanceof DocumentInputSource)) {
            try {
                this.reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (SAXException e) {
                throw new FOPException(e);
            }
            catch (ParserConfigurationException e) {
                throw new FOPException(e);
            }
        }
        if (this.source instanceof DocumentInputSource) {
            this.render(((DocumentInputSource)this.source).getDocument());
        } else {
            this.render(this.reader, this.source);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

