/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.tools.xslt.XSLTransform;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XSLTInputHandler
extends InputHandler {
    private File xmlfile;
    private File xsltfile;
    private boolean useOldTransform = false;
    private boolean gotParser = false;
    static /* synthetic */ Class class$java$io$File;

    public XSLTInputHandler(File xmlfile, File xsltfile) {
        this.xmlfile = xmlfile;
        this.xsltfile = xsltfile;
    }

    public InputSource getInputSource() {
        if (!this.gotParser) {
            throw new IllegalStateException("The method getParser() must be called and the parser used when using XSLTInputHandler");
        }
        if (this.useOldTransform) {
            try {
                Writer writer;
                File tmpFile = null;
                if (this.xmlfile.length() > 500000L) {
                    tmpFile = new File(this.xmlfile.getName() + ".fo.tmp");
                    writer = new FileWriter(tmpFile);
                } else {
                    writer = new StringWriter();
                }
                XSLTransform.transform(this.xmlfile.getCanonicalPath(), this.xsltfile.getCanonicalPath(), writer);
                writer.flush();
                writer.close();
                Reader reader = tmpFile != null ? new FileReader(tmpFile) : new StringReader(writer.toString());
                return new InputSource(reader);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return InputHandler.fileInputSource(this.xmlfile);
    }

    public XMLReader getParser() throws FOPException {
        this.gotParser = true;
        XMLReader result = null;
        try {
            Class<?> transformer = Class.forName("javax.xml.transform.Transformer");
            transformer = Class.forName("org.apache.fop.apps.TraxInputHandler");
            Class[] argTypes = new Class[]{class$java$io$File == null ? (class$java$io$File = XSLTInputHandler.class$("java.io.File")) : class$java$io$File, class$java$io$File == null ? (class$java$io$File = XSLTInputHandler.class$("java.io.File")) : class$java$io$File};
            Method getFilterMethod = transformer.getMethod("getXMLFilter", argTypes);
            Object[] args = new File[]{this.xmlfile, this.xsltfile};
            Object obj = getFilterMethod.invoke(null, args);
            if (obj instanceof XMLReader) {
                result = (XMLReader)obj;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new FOPException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new FOPException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new FOPException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new FOPException(ex);
        }
        if (result == null) {
            this.useOldTransform = true;
            result = InputHandler.createParser();
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

