/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.area.Resolveable;
import org.apache.fop.area.StorePagesModel;
import org.apache.fop.area.Title;
import org.apache.fop.area.TreeExt;
import org.apache.fop.render.Renderer;

public class AreaTree {
    private AreaTreeModel model;
    private Map idLocations = new HashMap();
    private Map resolve = new HashMap();
    private List treeExtensions = new ArrayList();

    public static RenderPagesModel createRenderPagesModel(Renderer rend) {
        return new RenderPagesModel(rend);
    }

    public static StorePagesModel createStorePagesModel() {
        return new StorePagesModel();
    }

    public void setTreeModel(AreaTreeModel m) {
        this.model = m;
    }

    public AreaTreeModel getAreaTreeModel() {
        return this.model;
    }

    public void startPageSequence(Title title) {
        this.model.startPageSequence(title);
    }

    public void addPage(PageViewport page) {
        this.model.addPage(page);
    }

    public void addIDRef(String id, PageViewport pv) {
        ArrayList<PageViewport> list = (ArrayList<PageViewport>)this.idLocations.get(id);
        if (list == null) {
            list = new ArrayList<PageViewport>();
            this.idLocations.put(id, list);
        }
        list.add(pv);
        Set todo = (Set)this.resolve.get(id);
        if (todo != null) {
            Iterator iter = todo.iterator();
            while (iter.hasNext()) {
                Resolveable res = (Resolveable)iter.next();
                res.resolve(id, list);
            }
            this.resolve.remove(id);
        }
    }

    public List getIDReferences(String id) {
        return (List)this.idLocations.get(id);
    }

    public void addUnresolvedID(String id, Resolveable res) {
        HashSet<Resolveable> todo = (HashSet<Resolveable>)this.resolve.get(id);
        if (todo == null) {
            todo = new HashSet<Resolveable>();
            this.resolve.put(id, todo);
        }
        todo.add(res);
    }

    public void addTreeExtension(TreeExt ext) {
        this.treeExtensions.add(ext);
        if (ext.isResolveable()) {
            Resolveable res = (Resolveable)((Object)ext);
            String[] ids = res.getIDs();
            int count = 0;
            while (count < ids.length) {
                if (this.idLocations.containsKey(ids[count])) {
                    res.resolve(ids[count], (List)this.idLocations.get(ids[count]));
                } else {
                    HashSet<TreeExt> todo = (HashSet<TreeExt>)this.resolve.get(ids[count]);
                    if (todo == null) {
                        todo = new HashSet<TreeExt>();
                        this.resolve.put(ids[count], todo);
                    }
                    todo.add(ext);
                }
                ++count;
            }
        } else {
            this.handleTreeExtension(ext, 0);
        }
    }

    public void handleTreeExtension(TreeExt ext, int when) {
        this.model.addExtension(ext, when);
    }

    public void endDocument() {
        Iterator iter = this.resolve.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Set list = (Set)this.resolve.get(id);
            Iterator resIter = list.iterator();
            while (resIter.hasNext()) {
                Resolveable res = (Resolveable)resIter.next();
                if (res.isResolved()) continue;
                res.resolve(id, null);
            }
        }
        this.model.endDocument();
    }
}

