/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.PropertyException;

public class MixedLength
extends Length {
    private Vector lengths;

    public MixedLength(Vector lengths) {
        this.lengths = lengths;
    }

    protected void computeValue() {
        int computedValue = 0;
        boolean bAllComputed = true;
        Enumeration e = this.lengths.elements();
        while (e.hasMoreElements()) {
            Length l = (Length)e.nextElement();
            computedValue += l.getValue();
            if (l.isComputed()) continue;
            bAllComputed = false;
        }
        this.setComputedValue(computedValue, bAllComputed);
    }

    public double getTableUnits() {
        double tableUnits = 0.0;
        Enumeration e = this.lengths.elements();
        while (e.hasMoreElements()) {
            tableUnits += ((Length)e.nextElement()).getTableUnits();
        }
        return tableUnits;
    }

    public void resolveTableUnit(double dTableUnit) {
        Enumeration e = this.lengths.elements();
        while (e.hasMoreElements()) {
            ((Length)e.nextElement()).resolveTableUnit(dTableUnit);
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        Enumeration e = this.lengths.elements();
        while (e.hasMoreElements()) {
            if (sbuf.length() > 0) {
                sbuf.append('+');
            }
            sbuf.append(e.nextElement().toString());
        }
        return sbuf.toString();
    }

    public Numeric asNumeric() {
        Numeric numeric = null;
        Enumeration e = this.lengths.elements();
        while (e.hasMoreElements()) {
            Length l = (Length)e.nextElement();
            if (numeric == null) {
                numeric = l.asNumeric();
                continue;
            }
            try {
                Numeric sum;
                numeric = sum = numeric.add(l.asNumeric());
            }
            catch (PropertyException pe) {
                System.err.println("Can't convert MixedLength to Numeric: " + pe);
            }
        }
        return numeric;
    }
}

