/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.extensions;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.extensions.BookmarkData;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Label;
import org.apache.fop.fo.FONode;
import org.xml.sax.Attributes;

public class Outline
extends ExtensionObj {
    private Label label;
    private ArrayList outlines = new ArrayList();
    private String internalDestination;
    private String externalDestination;

    public Outline(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        this.internalDestination = attlist.getValue("internal-destination");
        this.externalDestination = attlist.getValue("external-destination");
        if (this.externalDestination != null && !this.externalDestination.equals("")) {
            this.getLogger().warn("fox:outline external-destination not supported currently.");
        }
        if (this.internalDestination == null || this.internalDestination.equals("")) {
            this.getLogger().warn("fox:outline requires an internal-destination.");
        }
    }

    protected void addChild(FONode obj) {
        if (obj instanceof Label) {
            this.label = (Label)obj;
        } else if (obj instanceof Outline) {
            this.outlines.add(obj);
        }
    }

    public BookmarkData getData() {
        BookmarkData data = new BookmarkData(this.internalDestination);
        data.setLabel(this.getLabel());
        int count = 0;
        while (count < this.outlines.size()) {
            Outline out = (Outline)this.outlines.get(count);
            data.addSubData(out.getData());
            ++count;
        }
        return data;
    }

    public String getLabel() {
        return this.label == null ? "" : this.label.toString();
    }
}

