/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.fo.AbstractCharIterator;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.TextInfo;
import org.apache.fop.layout.TextState;
import org.apache.fop.layoutmgr.TextLayoutManager;

public class FOText
extends FObj {
    protected char[] ca;
    protected int start = 0;
    protected int length;
    TextInfo textInfo;
    TextState ts;

    public FOText(char[] chars, int s, int e, TextInfo ti) {
        super(null);
        this.ca = new char[e - s];
        System.arraycopy(chars, s, this.ca, 0, e - s);
        this.length = e - s;
        this.textInfo = ti;
    }

    public void setStructHandler(StructureHandler st) {
        super.setStructHandler(st);
        this.structHandler.characters(this.ca, this.start, this.length);
    }

    public boolean willCreateArea() {
        if (this.textInfo.whiteSpaceCollapse == 29 && this.length > 0) {
            return true;
        }
        int i = this.start;
        while (i < this.start + this.length) {
            char ch = this.ca[i];
            if (ch != ' ' && ch != '\n' && ch != '\r' && ch != '\t') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addLayoutManager(List list) {
        if (this.length == 0) {
            return;
        }
        if (this.length < this.ca.length) {
            char[] tmp = this.ca;
            this.ca = new char[this.length];
            System.arraycopy(tmp, 0, this.ca, 0, this.length);
        }
        TextLayoutManager lm = new TextLayoutManager(this.ca, this.textInfo);
        lm.setFObj(this);
        list.add(lm);
    }

    public CharIterator charIterator() {
        return new TextCharIterator();
    }

    private class TextCharIterator
    extends AbstractCharIterator {
        private int curIndex = 0;

        private TextCharIterator() {
        }

        public boolean hasNext() {
            return this.curIndex < FOText.this.length;
        }

        public char nextChar() {
            if (this.curIndex < FOText.this.length) {
                return FOText.this.ca[this.curIndex++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.curIndex > 0 && this.curIndex < FOText.this.length) {
                System.arraycopy(FOText.this.ca, this.curIndex, FOText.this.ca, this.curIndex - 1, FOText.this.length - this.curIndex);
                --FOText.this.length;
                --this.curIndex;
            } else if (this.curIndex == FOText.this.length) {
                this.curIndex = --FOText.this.length;
            }
        }

        public void replaceChar(char c) {
            if (this.curIndex > 0 && this.curIndex <= FOText.this.length) {
                FOText.this.ca[this.curIndex - 1] = c;
            }
        }
    }
}

