/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.NoSuchElementException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.layout.BorderAndPadding;

public class InlineCharIterator
extends RecursiveCharIterator {
    private boolean bStartBoundary = false;
    private boolean bEndBoundary = false;

    public InlineCharIterator(FObj fobj, BorderAndPadding bap) {
        super(fobj);
        this.checkBoundaries(bap);
    }

    private void checkBoundaries(BorderAndPadding bap) {
        this.bStartBoundary = bap.getBorderLeftWidth(false) > 0 || bap.getPaddingLeft(false) > 0;
        this.bEndBoundary = bap.getBorderRightWidth(false) > 0 || bap.getPaddingRight(false) > 0;
    }

    public boolean hasNext() {
        if (this.bStartBoundary) {
            return true;
        }
        return super.hasNext() || this.bEndBoundary;
    }

    public char nextChar() throws NoSuchElementException {
        if (this.bStartBoundary) {
            this.bStartBoundary = false;
            return '\u0000';
        }
        try {
            return super.nextChar();
        }
        catch (NoSuchElementException e) {
            if (this.bEndBoundary) {
                this.bEndBoundary = false;
                return '\u0000';
            }
            throw e;
        }
    }
}

