/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public abstract class XMLObj
extends FONode {
    private Attributes attr = null;
    protected Element element;
    protected Document doc;
    protected static HashMap ns = new HashMap();

    public XMLObj(FONode parent) {
        super(parent);
    }

    public void setName(String str) {
        this.name = str;
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        this.attr = attlist;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Point2D getDimension(Point2D view) {
        return null;
    }

    public abstract String getNameSpace();

    public String getDocumentNamespace() {
        return this.getNameSpace();
    }

    public void addElement(Document doc, Element parent) {
        this.doc = doc;
        this.element = doc.createElementNS(this.getNameSpace(), this.name);
        int count = 0;
        while (count < this.attr.getLength()) {
            String rf = this.attr.getValue(count);
            String qname = this.attr.getQName(count);
            int idx = qname.indexOf(":");
            if (idx == -1) {
                this.element.setAttribute(qname, rf);
            } else {
                String pref = qname.substring(0, idx);
                String tail = qname.substring(idx + 1);
                if (pref.equals("xmlns")) {
                    ns.put(tail, rf);
                } else {
                    this.element.setAttributeNS((String)ns.get(pref), tail, rf);
                }
            }
            ++count;
        }
        this.attr = null;
        parent.appendChild(this.element);
    }

    public void buildTopLevel(Document doc, Element svgRoot) {
        int count = 0;
        while (count < this.attr.getLength()) {
            String rf = this.attr.getValue(count);
            String qname = this.attr.getQName(count);
            int idx = qname.indexOf(":");
            if (idx == -1) {
                this.element.setAttribute(qname, rf);
            } else {
                String pref = qname.substring(0, idx);
                String tail = qname.substring(idx + 1);
                if (pref.equals("xmlns")) {
                    ns.put(tail, rf);
                } else {
                    this.element.setAttributeNS((String)ns.get(pref), tail, rf);
                }
            }
            ++count;
        }
    }

    public Document createBasicDocument() {
        this.doc = null;
        this.element = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            this.doc = fact.newDocumentBuilder().newDocument();
            Element el = this.doc.createElement(this.name);
            this.doc.appendChild(el);
            this.element = this.doc.getDocumentElement();
            this.buildTopLevel(this.doc, this.element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.doc;
    }

    protected void addChild(FONode child) {
        if (child instanceof XMLObj) {
            ((XMLObj)child).addElement(this.doc, this.element);
        } else {
            this.getLogger().debug("Invalid element: " + child.getName() + " inside foreign xml markup");
        }
    }

    protected void addCharacters(char[] data, int start, int length) {
        String str = new String(data, start, length - start);
        Text text = this.doc.createTextNode(str);
        this.element.appendChild(text);
    }

    static {
        ns.put("xlink", "http://www.w3.org/1999/xlink");
    }
}

