/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.Vector;
import org.apache.fop.datatypes.FixedLength;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.MixedLength;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.datatypes.TableColLength;
import org.apache.fop.fo.expr.PropertyException;

public class Numeric {
    public static final int ABS_LENGTH = 1;
    public static final int PC_LENGTH = 2;
    public static final int TCOL_LENGTH = 4;
    private int valType;
    private double absValue;
    private double pcValue;
    private PercentBase pcBase = null;
    private double tcolValue;
    private int dim;

    protected Numeric(int valType, double absValue, double pcValue, double tcolValue, int dim, PercentBase pcBase) {
        this.valType = valType;
        this.absValue = absValue;
        this.pcValue = pcValue;
        this.tcolValue = tcolValue;
        this.dim = dim;
        this.pcBase = pcBase;
    }

    public Numeric(Number num) {
        this(1, num.doubleValue(), 0.0, 0.0, 0, null);
    }

    public Numeric(FixedLength l) {
        this(1, l.getValue(), 0.0, 0.0, 1, null);
    }

    public Numeric(PercentLength pclen) {
        this(2, 0.0, pclen.value(), 0.0, 1, pclen.getBaseLength());
    }

    public Numeric(TableColLength tclen) {
        this(4, 0.0, 0.0, tclen.getTableUnits(), 1, null);
    }

    public Length asLength() {
        if (this.dim == 1) {
            Vector<Length> len = new Vector<Length>(3);
            if ((this.valType & 1) != 0) {
                len.add(new FixedLength((int)this.absValue));
            }
            if ((this.valType & 2) != 0) {
                len.add(new PercentLength(this.pcValue, this.pcBase));
            }
            if ((this.valType & 4) != 0) {
                len.add(new TableColLength(this.tcolValue));
            }
            if (len.size() == 1) {
                return (Length)len.elementAt(0);
            }
            return new MixedLength(len);
        }
        return null;
    }

    public Number asNumber() {
        return this.asDouble();
    }

    public Double asDouble() {
        if (this.dim == 0 && this.valType == 1) {
            return new Double(this.absValue);
        }
        return null;
    }

    private boolean isMixedType() {
        int ntype = 0;
        int t = this.valType;
        while (t != 0) {
            if ((t & 1) != 0) {
                ++ntype;
            }
            t >>= 1;
        }
        return ntype > 1;
    }

    public Numeric subtract(Numeric op) throws PropertyException {
        if (this.dim == op.dim) {
            PercentBase npcBase = (this.valType & 2) != 0 ? this.pcBase : op.pcBase;
            return new Numeric(this.valType | op.valType, this.absValue - op.absValue, this.pcValue - op.pcValue, this.tcolValue - op.tcolValue, this.dim, npcBase);
        }
        throw new PropertyException("Can't add Numerics of different dimensions");
    }

    public Numeric add(Numeric op) throws PropertyException {
        if (this.dim == op.dim) {
            PercentBase npcBase = (this.valType & 2) != 0 ? this.pcBase : op.pcBase;
            return new Numeric(this.valType | op.valType, this.absValue + op.absValue, this.pcValue + op.pcValue, this.tcolValue + op.tcolValue, this.dim, npcBase);
        }
        throw new PropertyException("Can't add Numerics of different dimensions");
    }

    public Numeric multiply(Numeric op) throws PropertyException {
        if (this.dim == 0) {
            return new Numeric(op.valType, this.absValue * op.absValue, this.absValue * op.pcValue, this.absValue * op.tcolValue, op.dim, op.pcBase);
        }
        if (op.dim == 0) {
            double opval = op.absValue;
            return new Numeric(this.valType, opval * this.absValue, opval * this.pcValue, opval * this.tcolValue, this.dim, this.pcBase);
        }
        if (this.valType == op.valType && !this.isMixedType()) {
            PercentBase npcBase = (this.valType & 2) != 0 ? this.pcBase : op.pcBase;
            return new Numeric(this.valType, this.absValue * op.absValue, this.pcValue * op.pcValue, this.tcolValue * op.tcolValue, this.dim + op.dim, npcBase);
        }
        throw new PropertyException("Can't multiply mixed Numerics");
    }

    public Numeric divide(Numeric op) throws PropertyException {
        if (this.dim == 0) {
            return new Numeric(op.valType, this.absValue / op.absValue, this.absValue / op.pcValue, this.absValue / op.tcolValue, -op.dim, op.pcBase);
        }
        if (op.dim == 0) {
            double opval = op.absValue;
            return new Numeric(this.valType, this.absValue / opval, this.pcValue / opval, this.tcolValue / opval, this.dim, this.pcBase);
        }
        if (this.valType == op.valType && !this.isMixedType()) {
            PercentBase npcBase = (this.valType & 2) != 0 ? this.pcBase : op.pcBase;
            return new Numeric(this.valType, this.valType == 1 ? this.absValue / op.absValue : 0.0, this.valType == 2 ? this.pcValue / op.pcValue : 0.0, this.valType == 4 ? this.tcolValue / op.tcolValue : 0.0, this.dim - op.dim, npcBase);
        }
        throw new PropertyException("Can't divide mixed Numerics.");
    }

    public Numeric abs() {
        return new Numeric(this.valType, Math.abs(this.absValue), Math.abs(this.pcValue), Math.abs(this.tcolValue), this.dim, this.pcBase);
    }

    public Numeric max(Numeric op) throws PropertyException {
        double rslt = 0.0;
        if (this.dim == op.dim && this.valType == op.valType && !this.isMixedType()) {
            if (this.valType == 1) {
                rslt = this.absValue - op.absValue;
            } else if (this.valType == 2) {
                rslt = this.pcValue - op.pcValue;
            } else if (this.valType == 4) {
                rslt = this.tcolValue - op.tcolValue;
            }
            if (rslt > 0.0) {
                return this;
            }
            return op;
        }
        throw new PropertyException("Arguments to max() must have same dimension and value type.");
    }

    public Numeric min(Numeric op) throws PropertyException {
        double rslt = 0.0;
        if (this.dim == op.dim && this.valType == op.valType && !this.isMixedType()) {
            if (this.valType == 1) {
                rslt = this.absValue - op.absValue;
            } else if (this.valType == 2) {
                rslt = this.pcValue - op.pcValue;
            } else if (this.valType == 4) {
                rslt = this.tcolValue - op.tcolValue;
            }
            if (rslt > 0.0) {
                return op;
            }
            return this;
        }
        throw new PropertyException("Arguments to min() must have same dimension and value type.");
    }
}

