/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.io.Serializable;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutProcessor;

public class BasicLink
extends Inline {
    private String link = null;
    private boolean external = false;

    public BasicLink(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List lms) {
        this.setup();
        InlineStackingLayoutManager lm = new InlineStackingLayoutManager(){

            protected InlineParent createArea() {
                InlineParent area = super.createArea();
                BasicLink.this.setupLinkArea(this.parentLM, area);
                return area;
            }
        };
        lm.setUserAgent(this.getUserAgent());
        lm.setFObj(this);
        lm.setLMiter(new LMiter(this.children.listIterator()));
        lms.add(lm);
    }

    protected void setupLinkArea(LayoutProcessor parentLM, InlineParent area) {
        if (this.link == null) {
            return;
        }
        if (this.external) {
            area.addTrait(Trait.EXTERNAL_LINK, this.link);
        } else {
            PageViewport page = parentLM.resolveRefID(this.link);
            if (page != null) {
                area.addTrait(Trait.INTERNAL_LINK, page.getKey());
            } else {
                LinkResolver res = new LinkResolver(this.link, area);
                parentLM.addUnresolvedArea(this.link, res);
            }
        }
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        String ext = this.properties.get("external-destination").getString();
        this.setupID();
        String internal = this.properties.get("internal-destination").getString();
        if (ext.length() > 0) {
            this.link = ext;
            this.external = true;
        } else if (internal.length() > 0) {
            this.link = internal;
        } else {
            this.getLogger().error("basic-link requires an internal or external destination");
        }
    }

    protected boolean containsMarkers() {
        return true;
    }

    protected static class LinkResolver
    implements Resolveable,
    Serializable {
        private boolean resolved = false;
        private String idRef;
        private Area area;

        public LinkResolver(String id, Area a) {
            this.idRef = id;
            this.area = a;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public String[] getIDs() {
            return new String[]{this.idRef};
        }

        public void resolve(String id, List pages) {
            this.resolved = true;
            if (this.idRef.equals(id) && pages != null) {
                PageViewport page = (PageViewport)pages.get(0);
                this.area.addTrait(Trait.INTERNAL_LINK, page.getKey());
            }
        }
    }
}

