/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.xml.sax.Attributes;

public class BlockContainer
extends FObj {
    private ColorType backgroundColor;
    private int position;
    private int top;
    private int bottom;
    private int left;
    private int right;
    private int width;
    private int height;
    private int span;

    public BlockContainer(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        this.span = this.properties.get("span").getEnum();
        this.setupID();
    }

    public void addLayoutManager(List list) {
        BlockContainerLayoutManager blm = new BlockContainerLayoutManager();
        blm.setUserAgent(this.getUserAgent());
        blm.setFObj(this);
        blm.setOverflow(this.properties.get("overflow").getEnum());
        list.add(blm);
    }

    public void setup() {
        AbsolutePositionProps mAbsProps = this.propMgr.getAbsolutePositionProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        this.setupID();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.width = this.properties.get("width").getLength().getValue();
        this.height = this.properties.get("height").getLength().getValue();
        this.span = this.properties.get("span").getEnum();
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    protected boolean containsMarkers() {
        return true;
    }

    public int getSpan() {
        return this.span;
    }
}

