/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.xml.sax.Attributes;

public class Flow
extends FObj {
    private PageSequence pageSequence;
    private ArrayList markerSnapshot;
    private String flowName;
    private int contentWidth;

    public Flow(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (!this.parent.getName().equals("fo:page-sequence")) {
            throw new FOPException("flow must be child of page-sequence, not " + this.parent.getName());
        }
        this.pageSequence = (PageSequence)this.parent;
        this.setFlowName(this.getProperty("flow-name").getString());
        this.structHandler.startFlow(this);
    }

    public void end() {
        this.structHandler.endFlow(this);
    }

    protected void setFlowName(String name) throws FOPException {
        if (name == null || name.equals("")) {
            throw new FOPException("A 'flow-name' is required for " + this.getName());
        }
        this.flowName = name;
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected void setContentWidth(int contentWidth) {
        this.contentWidth = contentWidth;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public void addLayoutManager(List list) {
        FlowLayoutManager lm = new FlowLayoutManager();
        lm.setUserAgent(this.getUserAgent());
        lm.setFObj(this);
        list.add(lm);
    }
}

