/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.InlineCharIterator;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.xml.sax.Attributes;

public class Inline
extends FObjMixed {
    protected boolean underlined = false;
    protected boolean overlined = false;
    protected boolean lineThrough = false;

    public Inline(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (this.parent.getName().equals("fo:flow")) {
            throw new FOPException("inline formatting objects cannot be directly under flow");
        }
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        int textDecoration = this.properties.get("text-decoration").getEnum();
        if (textDecoration == 99) {
            this.underlined = true;
        }
        if (textDecoration == 64) {
            this.overlined = true;
        }
        if (textDecoration == 46) {
            this.lineThrough = true;
        }
    }

    protected boolean containsMarkers() {
        return true;
    }

    public CharIterator charIterator() {
        return new InlineCharIterator((FObj)this, this.propMgr.getBorderAndPadding());
    }
}

