/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.list.ListItemLayoutManager;

public class ListItem
extends FObj {
    private ListItemLabel label = null;
    private ListItemBody body = null;
    private int align;
    private int alignLast;
    private int breakBefore;
    private int breakAfter;
    private int lineHeight;
    private int startIndent;
    private int endIndent;
    private int spaceBefore;
    private int spaceAfter;

    public ListItem(FONode parent) {
        super(parent);
    }

    public void addLayoutManager(List list) {
        if (this.label != null && this.body != null) {
            ListItemLayoutManager blm = new ListItemLayoutManager();
            blm.setUserAgent(this.getUserAgent());
            blm.setFObj(this);
            blm.setLabel(this.label.getItemLayoutManager());
            blm.setBody(this.body.getItemLayoutManager());
            list.add(blm);
        } else {
            this.getLogger().error("list-item requires list-item-label and list-item-body");
        }
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.align = this.properties.get("text-align").getEnum();
        this.alignLast = this.properties.get("text-align-last").getEnum();
        this.lineHeight = this.properties.get("line-height").getLength().getValue();
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().getValue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().getValue();
    }

    public void addChild(FONode child) {
        if ("fo:list-item-label".equals(child.getName())) {
            this.label = (ListItemLabel)child;
        } else if ("fo:list-item-body".equals(child.getName())) {
            this.body = (ListItemBody)child;
        } else if ("fo:marker".equals(child.getName())) {
            // empty if block
        }
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    protected boolean containsMarkers() {
        return true;
    }
}

