/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class Table
extends FObj {
    private static final int MINCOLWIDTH = 10000;
    protected ArrayList columns = null;
    private TableBody tableHeader = null;
    private TableBody tableFooter = null;
    private boolean omitHeaderAtBreak = false;
    private boolean omitFooterAtBreak = false;
    private int breakBefore;
    private int breakAfter;
    private int spaceBefore;
    private int spaceAfter;
    private ColorType backgroundColor;
    private LengthRange ipd;
    private int height;
    private boolean bAutoLayout = false;
    private int contentWidth = 0;
    private int optIPD;
    private int minIPD;
    private int maxIPD;

    public Table(FONode parent) {
        super(parent);
    }

    protected void addChild(FONode child) {
        if (child.getName().equals("fo:table-column")) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(((TableColumn)child).getLayoutManager());
        } else if (child.getName().equals("fo:table-footer")) {
            this.tableFooter = (TableBody)child;
        } else if (child.getName().equals("fo:table-header")) {
            this.tableHeader = (TableBody)child;
        } else {
            super.addChild(child);
        }
    }

    public void addLayoutManager(List list) {
        TableLayoutManager tlm = new TableLayoutManager();
        tlm.setUserAgent(this.getUserAgent());
        tlm.setFObj(this);
        tlm.setColumns(this.columns);
        if (this.tableHeader != null) {
            tlm.setTableHeader(this.tableHeader.getLayoutManager());
        }
        if (this.tableFooter != null) {
            tlm.setTableFooter(this.tableFooter.getLayoutManager());
        }
        list.add(tlm);
    }

    public void setup() {
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginProps mProps = this.propMgr.getMarginProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        this.setupID();
        this.breakBefore = this.properties.get("break-before").getEnum();
        this.breakAfter = this.properties.get("break-after").getEnum();
        this.spaceBefore = this.properties.get("space-before.optimum").getLength().getValue();
        this.spaceAfter = this.properties.get("space-after.optimum").getLength().getValue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.ipd = this.properties.get("inline-progression-dimension").getLengthRange();
        this.height = this.properties.get("height").getLength().getValue();
        this.bAutoLayout = this.properties.get("table-layout").getEnum() == 8;
        this.omitHeaderAtBreak = this.properties.get("table-omit-header-at-break").getEnum() == 98;
        this.omitFooterAtBreak = this.properties.get("table-omit-footer-at-break").getEnum() == 98;
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    protected boolean containsMarkers() {
        return true;
    }
}

