/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Attributes;

public class PageSequenceMaster
extends FObj {
    private LayoutMasterSet layoutMasterSet;
    private List subSequenceSpecifiers;
    private SubSequenceSpecifier currentSubSequence;
    private int currentSubSequenceNumber;
    private String masterName;

    public PageSequenceMaster(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        this.subSequenceSpecifiers = new ArrayList();
        if (this.parent.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)this.parent;
            String pm = this.properties.get("master-name").getString();
            if (pm == null) {
                this.getLogger().warn("page-sequence-master does not have a master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addPageSequenceMaster(pm, this);
            }
        } else {
            throw new FOPException("fo:page-sequence-master must be child of fo:layout-master-set, not " + this.parent.getName());
        }
    }

    protected void addSubsequenceSpecifier(SubSequenceSpecifier pageMasterReference) {
        this.subSequenceSpecifiers.add(pageMasterReference);
    }

    private SubSequenceSpecifier getNextSubSequence() {
        ++this.currentSubSequenceNumber;
        if (this.currentSubSequenceNumber >= 0 && this.currentSubSequenceNumber < this.subSequenceSpecifiers.size()) {
            return (SubSequenceSpecifier)this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
        }
        return null;
    }

    public void reset() {
        this.currentSubSequenceNumber = -1;
        this.currentSubSequence = null;
        int i = 0;
        while (i < this.subSequenceSpecifiers.size()) {
            ((SubSequenceSpecifier)this.subSequenceSpecifiers.get(i)).reset();
            ++i;
        }
    }

    public SimplePageMaster getNextSimplePageMaster(boolean isOddPage, boolean isFirstPage, boolean isBlankPage) throws FOPException {
        if (this.currentSubSequence == null) {
            this.currentSubSequence = this.getNextSubSequence();
            if (this.currentSubSequence == null) {
                throw new FOPException("no subsequences in page-sequence-master '" + this.masterName + "'");
            }
        }
        String pageMasterName = this.currentSubSequence.getNextPageMasterName(isOddPage, isFirstPage, isBlankPage);
        boolean canRecover = true;
        while (pageMasterName == null) {
            SubSequenceSpecifier nextSubSequence = this.getNextSubSequence();
            if (nextSubSequence == null) {
                if (!canRecover) {
                    throw new FOPException("subsequences exhausted in page-sequence-master '" + this.masterName + "', cannot recover");
                }
                this.getLogger().warn("subsequences exhausted in page-sequence-master '" + this.masterName + "', use previous subsequence");
                this.currentSubSequence.reset();
                canRecover = false;
            } else {
                this.currentSubSequence = nextSubSequence;
            }
            pageMasterName = this.currentSubSequence.getNextPageMasterName(isOddPage, isFirstPage, isBlankPage);
        }
        SimplePageMaster pageMaster = this.layoutMasterSet.getSimplePageMaster(pageMasterName);
        if (pageMaster == null) {
            throw new FOPException("No simple-page-master matching '" + pageMasterName + "' in page-sequence-master '" + this.masterName + "'");
        }
        return pageMaster;
    }
}

