/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.CTM;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.TraitSetter;
import org.xml.sax.Attributes;

public abstract class Region
extends FObj {
    private static final String PROP_REGION_NAME = "region-name";
    public static final String BEFORE = "before";
    public static final String START = "start";
    public static final String END = "end";
    public static final String AFTER = "after";
    public static final String BODY = "body";
    private SimplePageMaster layoutMaster;
    private String regionName;
    protected int overflow;
    protected int wm;

    protected Region(FONode parent) {
        super(parent);
    }

    public void handleAttrs(Attributes attlist) throws FOPException {
        super.handleAttrs(attlist);
        if (null == this.properties.get(PROP_REGION_NAME)) {
            this.setRegionName(this.getDefaultRegionName());
        } else if (this.properties.get(PROP_REGION_NAME).getString().equals("")) {
            this.setRegionName(this.getDefaultRegionName());
        } else {
            this.setRegionName(this.properties.get(PROP_REGION_NAME).getString());
            if (this.isReserved(this.getRegionName()) && !this.getRegionName().equals(this.getDefaultRegionName())) {
                throw new FOPException("region-name '" + this.regionName + "' for " + this.name + " not permitted.");
            }
        }
        if (!(this.parent instanceof SimplePageMaster)) {
            throw new FOPException(this.name + " must be child " + "of simple-page-master, not " + this.parent.getName());
        }
        this.layoutMaster = (SimplePageMaster)this.parent;
        this.wm = this.properties.get("writing-mode").getEnum();
    }

    public RegionViewport makeRegionViewport(FODimension reldims, CTM pageCTM) {
        Rectangle relRegionRect = this.getViewportRectangle(reldims);
        Rectangle2D absRegionRect = pageCTM.transform(relRegionRect);
        RegionViewport rv = new RegionViewport(absRegionRect);
        this.setRegionViewportTraits(rv);
        return rv;
    }

    protected void setRegionViewportTraits(RegionViewport r) {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        TraitSetter.addBorders(r, bap);
        TraitSetter.addBackground(r, bProps);
        this.overflow = this.properties.get("overflow").getEnum();
    }

    protected abstract Rectangle getViewportRectangle(FODimension var1);

    public RegionReference makeRegionReferenceArea(Rectangle2D absRegVPRect) {
        RegionReference r = new RegionReference(this.getRegionAreaClass());
        this.setRegionPosition(r, absRegVPRect);
        return r;
    }

    protected void setRegionPosition(RegionReference r, Rectangle2D absRegVPRect) {
        FODimension reldims = new FODimension(0, 0);
        r.setCTM(this.propMgr.getCTMandRelDims(absRegVPRect, reldims));
    }

    protected abstract int getRegionAreaClass();

    protected abstract String getDefaultRegionName();

    public abstract String getRegionClass();

    public String getRegionName() {
        return this.regionName;
    }

    private void setRegionName(String name) {
        this.regionName = name;
    }

    protected SimplePageMaster getPageMaster() {
        return this.layoutMaster;
    }

    protected boolean isReserved(String name) {
        return name.equals("xsl-region-before") || name.equals("xsl-region-start") || name.equals("xsl-region-end") || name.equals("xsl-region-after") || name.equals("xsl-before-float-separator") || name.equals("xsl-footnote-separator");
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    protected Region getSiblingRegion(String regionClass) {
        return this.layoutMaster.getRegion(regionClass);
    }

    public boolean getPrecedence() {
        return false;
    }

    public int getExtent() {
        return 0;
    }
}

