/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.RegionReference;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.MarginProps;

public class RegionBody
extends Region {
    private ColorType backgroundColor;

    public RegionBody(FONode parent) {
        super(parent);
    }

    protected Rectangle getViewportRectangle(FODimension reldims) {
        MarginProps mProps = this.propMgr.getMarginProps();
        int start = this.getRelMargin(0, "start-indent");
        Rectangle vpRect = this.wm == 47 || this.wm == 79 ? new Rectangle(start, mProps.spaceBefore, reldims.ipd - start - this.getRelMargin(1, "end-indent"), reldims.bpd - mProps.spaceBefore - mProps.spaceAfter) : new Rectangle(start, mProps.spaceBefore, reldims.bpd - mProps.spaceBefore - mProps.spaceAfter, reldims.ipd - start - this.getRelMargin(1, "end-indent"));
        return vpRect;
    }

    private int getRelMargin(int reldir, String sRelPropName) {
        FObj parent = (FObj)this.getParent();
        String sPropName = "margin-" + parent.properties.wmRelToAbs(reldir);
        Property prop = this.properties.getExplicitBaseProp(sPropName);
        if (prop == null) {
            prop = this.properties.getExplicitBaseProp(sRelPropName);
        }
        return prop != null ? prop.getLength().getValue() : 0;
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    public String getRegionClass() {
        return "body";
    }

    public int getRegionAreaClass() {
        return 2;
    }

    public RegionReference makeRegionReferenceArea(Rectangle2D absRegVPRect) {
        BodyRegion body = new BodyRegion();
        this.setRegionPosition(body, absRegVPRect);
        int columnCount = this.properties.get("column-count").getNumber().intValue();
        if (columnCount > 1 && this.overflow == 82) {
            this.getLogger().error("Setting 'column-count' to 1 because 'overflow' is set to 'scroll'");
            columnCount = 1;
        }
        body.setColumnCount(columnCount);
        int columnGap = this.properties.get("column-gap").getLength().getValue();
        body.setColumnGap(columnGap);
        return body;
    }
}

