/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.HashMap;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.CondLength;
import org.apache.fop.fo.CondLengthProperty;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class GenericCondBorderWidth
extends CondLengthProperty.Maker {
    private static final Property.Maker s_LengthMaker = new SP_LengthMaker("border-cond-width-template.length");
    private static final Property.Maker s_ConditionalityMaker = new SP_ConditionalityMaker("border-cond-width-template.conditionality");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("length");
    private Property m_defaultProp = null;
    static HashMap s_htKeywords = new HashMap(3);

    public static Property.Maker maker(String propName) {
        return new GenericCondBorderWidth(propName);
    }

    protected GenericCondBorderWidth(String name) {
        super(name);
    }

    public Property checkEnumValues(String value) {
        return this.m_shorthandMaker.checkEnumValues(value);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    protected Property.Maker getSubpropMaker(String subprop) {
        if (subprop.equals("length")) {
            return s_LengthMaker;
        }
        if (subprop.equals("conditionality")) {
            return s_ConditionalityMaker;
        }
        return super.getSubpropMaker(subprop);
    }

    protected Property setSubprop(Property baseProp, String subpropName, Property subProp) {
        CondLength val = baseProp.getCondLength();
        val.setComponent(subpropName, subProp, false);
        return baseProp;
    }

    public Property getSubpropValue(Property baseProp, String subpropName) {
        CondLength val = baseProp.getCondLength();
        return val.getComponent(subpropName);
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList pList, FObj fo) throws FOPException {
        CondLength p = new CondLength();
        Property subProp = this.getSubpropMaker("length").make(pList, this.getDefaultForLength(), fo);
        p.setComponent("length", subProp, true);
        subProp = this.getSubpropMaker("conditionality").make(pList, this.getDefaultForConditionality(), fo);
        p.setComponent("conditionality", subProp, true);
        return new CondLengthProperty(p);
    }

    protected String getDefaultForLength() {
        return "medium";
    }

    protected String getDefaultForConditionality() {
        return "";
    }

    public Property convertProperty(Property p, PropertyList pList, FObj fo) throws FOPException {
        if (p instanceof CondLengthProperty) {
            return p;
        }
        if (!(p instanceof EnumProperty)) {
            p = this.m_shorthandMaker.convertProperty(p, pList, fo);
        }
        if (p != null) {
            Property prop = this.makeCompound(pList, fo);
            CondLength pval = prop.getCondLength();
            pval.setComponent("length", p, false);
            return prop;
        }
        return null;
    }

    public boolean isInherited() {
        return false;
    }

    protected String checkValueKeywords(String keyword) {
        String value = (String)s_htKeywords.get(keyword);
        if (value == null) {
            return super.checkValueKeywords(keyword);
        }
        return value;
    }

    static {
        s_htKeywords.put("thin", "0.5pt");
        s_htKeywords.put("medium", "1pt");
        s_htKeywords.put("thick", "2pt");
    }

    private static class SP_ConditionalityMaker
    extends EnumProperty.Maker
    implements Enums.Conditionality {
        protected static final EnumProperty s_propDISCARD = new EnumProperty(18);
        protected static final EnumProperty s_propRETAIN = new EnumProperty(76);

        SP_ConditionalityMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("discard")) {
                return s_propDISCARD;
            }
            if (value.equals("retain")) {
                return s_propRETAIN;
            }
            return super.checkEnumValues(value);
        }
    }

    private static class SP_LengthMaker
    extends LengthProperty.Maker {
        static HashMap s_htKeywords = new HashMap(3);

        SP_LengthMaker(String sPropName) {
            super(sPropName);
        }

        protected String checkValueKeywords(String keyword) {
            String value = (String)s_htKeywords.get(keyword);
            if (value == null) {
                return super.checkValueKeywords(keyword);
            }
            return value;
        }

        static {
            s_htKeywords.put("thin", "0.5pt");
            s_htKeywords.put("medium", "1pt");
            s_htKeywords.put("thick", "2pt");
        }
    }

    public static interface Enums {

        public static interface Conditionality {
            public static final int DISCARD = 18;
            public static final int RETAIN = 76;
        }
    }
}

