/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageCache;
import org.apache.fop.image.ImageLoader;

class ContextImageCache
implements ImageCache {
    private boolean collective;
    private Map contextStore = Collections.synchronizedMap(new HashMap());
    private Set invalid = null;
    private Map weakStore = null;

    public ContextImageCache(boolean col) {
        this.collective = col;
        if (this.collective) {
            this.weakStore = Collections.synchronizedMap(new WeakHashMap());
            this.invalid = Collections.synchronizedSet(new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FopImage getImage(String url, FOUserAgent context) {
        ImageLoader im = null;
        ContextImageCache contextImageCache = this;
        synchronized (contextImageCache) {
            if (this.collective && this.invalid.contains(url)) {
                return null;
            }
            Context con = (Context)this.contextStore.get(context);
            if (con == null) {
                con = new Context(context, this.collective);
                this.contextStore.put(context, con);
            } else {
                if (con.invalid(url)) {
                    return null;
                }
                im = con.getImage(url);
            }
            if (im == null && this.collective) {
                Iterator i = this.contextStore.values().iterator();
                while (i.hasNext()) {
                    Context c = (Context)i.next();
                    if (c != con && (im = c.getImage(url)) != null) break;
                }
                if (im == null) {
                    im = (ImageLoader)this.weakStore.get(url);
                }
            }
            if (im != null) {
                con.putImage(url, im);
            } else {
                im = con.getImage(url, this);
            }
        }
        if (im != null) {
            return im.loadImage();
        }
        return null;
    }

    public void releaseImage(String url, FOUserAgent context) {
        Context con = (Context)this.contextStore.get(context);
        if (con != null) {
            if (this.collective) {
                ImageLoader im = con.getImage(url);
                this.weakStore.put(url, im);
            }
            con.releaseImage(url);
        }
    }

    public void invalidateImage(String url, FOUserAgent context) {
        Context con;
        if (this.collective) {
            if (this.invalid.size() > 100) {
                this.invalid.clear();
            }
            this.invalid.add(url);
        }
        if ((con = (Context)this.contextStore.get(context)) != null) {
            con.invalidateImage(url);
        }
    }

    public void removeContext(FOUserAgent context) {
        Context con = (Context)this.contextStore.get(context);
        if (con != null) {
            if (this.collective) {
                Map images = con.getImages();
                this.weakStore.putAll(images);
            }
            this.contextStore.remove(context);
        }
    }

    class Context {
        private Map images = Collections.synchronizedMap(new HashMap());
        private Set invalid = null;
        private FOUserAgent userAgent;

        public Context(FOUserAgent ua, boolean inv) {
            this.userAgent = ua;
            if (inv) {
                this.invalid = Collections.synchronizedSet(new HashSet());
            }
        }

        public ImageLoader getImage(String url, ImageCache c) {
            if (this.images.containsKey(url)) {
                return (ImageLoader)this.images.get(url);
            }
            ImageLoader loader = new ImageLoader(url, c, this.userAgent);
            this.images.put(url, loader);
            return loader;
        }

        public void putImage(String url, ImageLoader image) {
            this.images.put(url, image);
        }

        public ImageLoader getImage(String url) {
            return (ImageLoader)this.images.get(url);
        }

        public void releaseImage(String url) {
            this.images.remove(url);
        }

        public Map getImages() {
            return this.images;
        }

        public void invalidateImage(String url) {
            this.invalid.add(url);
        }

        public boolean invalid(String url) {
            return this.invalid.contains(url);
        }
    }
}

