/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageConsumer;
import org.apache.fop.pdf.PDFColor;

public class GifImage
extends AbstractFopImage {
    public GifImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    protected boolean loadBitmap(FOUserAgent ua) {
        int[] tmpMap;
        block14: {
            tmpMap = null;
            try {
                DummyConnection con = new DummyConnection(this.inputStream);
                ImageProducer ip = (ImageProducer)con.getContent();
                if (ip == null) {
                    return false;
                }
                FopImageConsumer consumer = new FopImageConsumer(ip);
                ip.startProduction(consumer);
                while (!consumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.height = consumer.getHeight();
                this.width = consumer.getWidth();
                try {
                    tmpMap = consumer.getImage();
                }
                catch (Exception ex) {
                    ua.getLogger().error("Image grabbing interrupted : " + ex.getMessage(), (Throwable)ex);
                    return false;
                }
                this.inputStream.close();
                this.inputStream = null;
                ColorModel cm = consumer.getColorModel();
                this.bitsPerPixel = 8;
                this.colorSpace = ColorSpace.getInstance(1004);
                if (cm.hasAlpha()) {
                    int transparencyType = cm.getTransparency();
                    if (transparencyType == 1) {
                        this.isTransparent = false;
                        break block14;
                    }
                    if (transparencyType == 2) {
                        if (cm instanceof IndexColorModel) {
                            IndexColorModel indexcm = (IndexColorModel)cm;
                            this.isTransparent = false;
                            byte[] alphas = new byte[indexcm.getMapSize()];
                            byte[] reds = new byte[indexcm.getMapSize()];
                            byte[] greens = new byte[indexcm.getMapSize()];
                            byte[] blues = new byte[indexcm.getMapSize()];
                            indexcm.getAlphas(alphas);
                            indexcm.getReds(reds);
                            indexcm.getGreens(greens);
                            indexcm.getBlues(blues);
                            int i = 0;
                            while (i < indexcm.getMapSize()) {
                                if ((alphas[i] & 0xFF) == 0) {
                                    this.isTransparent = true;
                                    this.transparentColor = new PDFColor(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                    break block14;
                                }
                                ++i;
                            }
                            break block14;
                        }
                        this.isTransparent = false;
                        break block14;
                    }
                    this.isTransparent = false;
                    break block14;
                }
                this.isTransparent = false;
            }
            catch (Exception ex) {
                ua.getLogger().error("Error while loading image  : " + ex.getClass() + " - " + ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        this.bitmapsSize = this.width * this.height * 3;
        this.bitmaps = new byte[this.bitmapsSize];
        int i = 0;
        while (i < this.height) {
            int j = 0;
            while (j < this.width) {
                int p = tmpMap[i * this.width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected static class DummyConnection
    extends URLConnection {
        private InputStream inputStream;

        DummyConnection(InputStream is) {
            super(null);
            this.inputStream = is;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public void connect() throws IOException {
        }

        public String getContentType() {
            return "image/gif";
        }

        public int getContentLength() {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }
}

