/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.image.ContextImageCache;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageCache;
import org.apache.fop.image.analyser.ImageReaderFactory;

public class ImageFactory {
    private static ImageFactory factory = new ImageFactory();
    private ImageCache cache = new ContextImageCache(true);
    static /* synthetic */ Class class$org$apache$fop$image$FopImage$ImageInfo;

    private ImageFactory() {
    }

    public static ImageFactory getInstance() {
        return factory;
    }

    public static String getURL(String href) {
        if ((href = href.trim()).startsWith("url(") && href.indexOf(")") != -1) {
            if ((href = href.substring(4, href.indexOf(")")).trim()).startsWith("'") && href.endsWith("'")) {
                href = href.substring(1, href.length() - 1);
            } else if (href.startsWith("\"") && href.endsWith("\"")) {
                href = href.substring(1, href.length() - 1);
            }
        }
        return href;
    }

    public FopImage getImage(String url, FOUserAgent context) {
        return this.cache.getImage(url, context);
    }

    public void releaseImage(String url, FOUserAgent context) {
        this.cache.releaseImage(url, context);
    }

    public void removeContext(FOUserAgent context) {
        this.cache.removeContext(context);
    }

    protected static FopImage loadImage(String href, FOUserAgent ua) {
        Logger log = ua.getLogger();
        InputStream in = ImageFactory.openStream(href, ua);
        if (in == null) {
            return null;
        }
        FopImage.ImageInfo imgInfo = null;
        try {
            imgInfo = ImageReaderFactory.make(href, in, ua);
        }
        catch (Exception e) {
            log.error("Error while recovering image information (" + href + ") : " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (imgInfo == null) {
            try {
                in.close();
                in = null;
            }
            catch (Exception e) {
                log.debug("Error closing the InputStream for the image", (Throwable)e);
            }
            log.error("No ImageReader for this type of image (" + href + ")");
            return null;
        }
        String imgMimeType = imgInfo.mimeType;
        String imgClassName = ImageFactory.getImageClassName(imgMimeType);
        if (imgClassName == null) {
            log.error("Unsupported image type (" + href + "): " + imgMimeType);
            return null;
        }
        Object imageInstance = null;
        Class<?> imageClass = null;
        try {
            imageClass = Class.forName(imgClassName);
            Class[] imageConstructorParameters = new Class[]{class$org$apache$fop$image$FopImage$ImageInfo == null ? (class$org$apache$fop$image$FopImage$ImageInfo = ImageFactory.class$("org.apache.fop.image.FopImage$ImageInfo")) : class$org$apache$fop$image$FopImage$ImageInfo};
            Constructor<?> imageConstructor = imageClass.getDeclaredConstructor(imageConstructorParameters);
            Object[] initArgs = new Object[]{imgInfo};
            imageInstance = imageConstructor.newInstance(initArgs);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            String msg = t != null ? t.getMessage() : ex.getMessage();
            log.error("Error creating FopImage object (" + href + "): " + msg, t == null ? ex : t);
            return null;
        }
        catch (Exception ex) {
            log.error("Error creating FopImage object (" + href + "): " + ex.getMessage(), (Throwable)ex);
            return null;
        }
        if (!(imageInstance instanceof FopImage)) {
            log.error("Error creating FopImage object (" + href + "): " + "class " + imageClass.getName() + " doesn't implement org.apache.fop.image.FopImage interface");
            return null;
        }
        return imageInstance;
    }

    protected static InputStream openStream(String href, FOUserAgent ua) {
        Logger log = ua.getLogger();
        URL absoluteURL = null;
        InputStream in = null;
        try {
            in = ua.getStream(href);
        }
        catch (IOException ioe) {
            log.error("Error while opening stream for (" + href + "): " + ioe.getMessage(), (Throwable)ioe);
            return null;
        }
        if (in == null) {
            try {
                try {
                    absoluteURL = new URL(href);
                }
                catch (MalformedURLException mue) {
                    absoluteURL = new URL("file:" + href);
                }
                in = absoluteURL.openStream();
            }
            catch (MalformedURLException mfue) {
                log.error("Error with image URL: " + mfue.getMessage(), (Throwable)mfue);
                return null;
            }
            catch (Exception e) {
                if (ua.getBaseURL() == null) {
                    log.error("Error with image URL: " + e.getMessage() + " and no base URL is specified", (Throwable)e);
                    return null;
                }
                try {
                    absoluteURL = new URL(ua.getBaseURL() + absoluteURL.getFile());
                }
                catch (MalformedURLException e_context) {
                    log.error("Invalid Image URL - error on relative URL: " + e_context.getMessage(), (Throwable)e_context);
                    return null;
                }
            }
        }
        try {
            if (in == null && absoluteURL != null) {
                in = absoluteURL.openStream();
            }
            if (in == null) {
                log.error("Could not resolve URI for image: " + href);
                return null;
            }
            return new BufferedInputStream(in);
        }
        catch (Exception e) {
            log.error("Error while opening stream for (" + href + "): " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getImageClassName(String imgMimeType) {
        String imgClassName = null;
        if ("image/gif".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.GifImage";
        } else if ("image/jpeg".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.JpegImage";
        } else if ("image/bmp".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.BmpImage";
        } else if ("image/eps".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.EPSImage";
        } else if ("image/png".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.JimiImage";
        } else if ("image/tga".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.JimiImage";
        } else if ("image/tiff".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.JimiImage";
        } else if ("image/svg+xml".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.XMLImage";
        } else if ("text/xml".equals(imgMimeType)) {
            imgClassName = "org.apache.fop.image.XMLImage";
        }
        return imgClassName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

