/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.CondLength;

public class BorderAndPadding
implements Cloneable {
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int START = 2;
    public static final int END = 3;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private ResolvedCondLength[] padding = new ResolvedCondLength[4];

    public Object clone() throws CloneNotSupportedException {
        BorderAndPadding bp = (BorderAndPadding)super.clone();
        bp.padding = (ResolvedCondLength[])this.padding.clone();
        bp.borderInfo = (BorderInfo[])this.borderInfo.clone();
        int i = 0;
        while (i < this.padding.length) {
            if (this.padding[i] != null) {
                bp.padding[i] = (ResolvedCondLength)this.padding[i].clone();
            }
            if (this.borderInfo[i] != null) {
                bp.borderInfo[i] = (BorderInfo)this.borderInfo[i].clone();
            }
            ++i;
        }
        return bp;
    }

    public void setBorder(int side, int style, CondLength width, ColorType color) {
        this.borderInfo[side] = new BorderInfo(style, width, color);
    }

    public void setPadding(int side, CondLength width) {
        this.padding[side] = new ResolvedCondLength(width);
    }

    public void setPaddingLength(int side, int iLength) {
        this.padding[side].iLength = iLength;
    }

    public void setBorderLength(int side, int iLength) {
        this.borderInfo[side].mWidth.iLength = iLength;
    }

    public int getBorderLeftWidth(boolean bDiscard) {
        return this.getBorderWidth(2, bDiscard);
    }

    public int getBorderRightWidth(boolean bDiscard) {
        return this.getBorderWidth(3, bDiscard);
    }

    public int getBorderTopWidth(boolean bDiscard) {
        return this.getBorderWidth(0, bDiscard);
    }

    public int getBorderBottomWidth(boolean bDiscard) {
        return this.getBorderWidth(1, bDiscard);
    }

    public int getPaddingLeft(boolean bDiscard) {
        return this.getPadding(2, bDiscard);
    }

    public int getPaddingRight(boolean bDiscard) {
        return this.getPadding(3, bDiscard);
    }

    public int getPaddingBottom(boolean bDiscard) {
        return this.getPadding(1, bDiscard);
    }

    public int getPaddingTop(boolean bDiscard) {
        return this.getPadding(0, bDiscard);
    }

    public int getBorderWidth(int side, boolean bDiscard) {
        if (this.borderInfo[side] == null || this.borderInfo[side].mStyle == 57 || bDiscard && this.borderInfo[side].mWidth.bDiscard) {
            return 0;
        }
        return this.borderInfo[side].mWidth.iLength;
    }

    public ColorType getBorderColor(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mColor;
        }
        return null;
    }

    public int getBorderStyle(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mStyle;
        }
        return 0;
    }

    public int getPadding(int side, boolean bDiscard) {
        if (this.padding[side] == null || bDiscard && this.padding[side].bDiscard) {
            return 0;
        }
        return this.padding[side].iLength;
    }

    public static class BorderInfo
    implements Cloneable {
        private int mStyle;
        private ColorType mColor;
        private ResolvedCondLength mWidth;

        BorderInfo(int style, CondLength width, ColorType color) {
            this.mStyle = style;
            this.mWidth = new ResolvedCondLength(width);
            this.mColor = color;
        }

        public Object clone() throws CloneNotSupportedException {
            BorderInfo bi = (BorderInfo)super.clone();
            bi.mWidth = (ResolvedCondLength)this.mWidth.clone();
            return bi;
        }
    }

    private static class ResolvedCondLength
    implements Cloneable {
        private int iLength;
        private boolean bDiscard;

        public ResolvedCondLength(CondLength length) {
            this.bDiscard = length.isDiscard();
            this.iLength = length.getLengthValue();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

