/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ListIterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public abstract class AbstractLayoutManager
implements LayoutProcessor {
    protected FOUserAgent userAgent;
    protected LayoutProcessor parentLM = null;
    protected FObj fobj;
    protected String foID = null;
    protected Map markers = null;
    private boolean bFinished = false;
    protected LayoutProcessor curChildLM = null;
    protected ListIterator childLMiter;
    protected boolean bInited = false;

    public void setFObj(FObj fo) {
        this.fobj = fo;
        this.foID = this.fobj.getID();
        this.markers = this.fobj.getMarkers();
        this.childLMiter = new LMiter(this.fobj.getChildren());
    }

    public void setUserAgent(FOUserAgent ua) {
        this.userAgent = ua;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    protected Logger getLogger() {
        return this.userAgent.getLogger();
    }

    public void setParent(LayoutProcessor lm) {
        this.parentLM = lm;
    }

    public boolean generatesInlineAreas() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected LayoutProcessor getChildLM() {
        if (this.curChildLM != null && !this.curChildLM.isFinished()) {
            return this.curChildLM;
        }
        if (this.childLMiter.hasNext()) {
            this.curChildLM = (LayoutProcessor)this.childLMiter.next();
            this.curChildLM.setUserAgent(this.getUserAgent());
            this.curChildLM.setParent(this);
            this.curChildLM.init();
            return this.curChildLM;
        }
        return null;
    }

    protected boolean hasMoreLM(LayoutManager prevLM) {
        if (prevLM != this.curChildLM) {
            return false;
        }
        return !this.childLMiter.hasNext();
    }

    protected void reset(Position pos) {
        LayoutProcessor lm;
        LayoutProcessor layoutProcessor = lm = pos != null ? pos.getLM() : null;
        if (this.curChildLM != lm) {
            if (this.childLMiter.hasPrevious() && this.curChildLM != (LayoutManager)this.childLMiter.previous()) {
                // empty if block
            }
            while (this.curChildLM != lm && this.childLMiter.hasPrevious()) {
                this.curChildLM.resetPosition(null);
                this.curChildLM = (LayoutProcessor)this.childLMiter.previous();
            }
            this.childLMiter.next();
        }
        if (this.curChildLM != null) {
            this.curChildLM.resetPosition(pos);
        }
        if (this.isFinished()) {
            this.setFinished(false);
        }
    }

    public void resetPosition(Position resetPos) {
    }

    public void init() {
        if (this.fobj != null && !this.bInited) {
            this.initProperties(this.fobj.getPropertyManager());
            this.bInited = true;
        }
    }

    protected void initProperties(PropertyManager pm) {
    }

    public boolean isFinished() {
        return this.bFinished;
    }

    public void setFinished(boolean fin) {
        this.bFinished = fin;
    }

    public BreakPoss getNextBreakPoss(LayoutContext context) {
        return null;
    }

    public boolean canBreakBefore(LayoutContext context) {
        return true;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
    }

    public void getWordChars(StringBuffer sbChars, Position bp1, Position bp2) {
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    protected void flush() {
    }

    public void addChild(Area childArea) {
    }

    public String getCurrentPageNumber() {
        return this.parentLM.getCurrentPageNumber();
    }

    public PageViewport resolveRefID(String ref) {
        return this.parentLM.resolveRefID(ref);
    }

    protected void addID() {
        if (this.foID != null) {
            this.addIDToPage(this.foID);
        }
    }

    public void addIDToPage(String id) {
        this.parentLM.addIDToPage(id);
    }

    public void addUnresolvedArea(String id, Resolveable res) {
        this.parentLM.addUnresolvedArea(id, res);
    }

    protected void addMarkers(boolean start, boolean isfirst) {
        if (this.markers != null) {
            this.addMarkerMap(this.markers, start, isfirst);
        }
    }

    public void addMarkerMap(Map marks, boolean start, boolean isfirst) {
        this.parentLM.addMarkerMap(marks, start, isfirst);
    }

    public Marker retrieveMarker(String name, int pos, int boundary) {
        return this.parentLM.retrieveMarker(name, pos, boundary);
    }
}

