/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.fo.TextInfo;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.LineLayoutManager;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.LayoutProps;

public class BlockLayoutManager
extends BlockStackingLayoutManager {
    private Block curBlockArea;
    private LayoutProps layoutProps;
    private BorderAndPadding borderProps;
    private BackgroundProps backgroundProps;
    private int lead = 12000;
    private int lineHeight = 14000;
    private int follow = 2000;
    private int iStartPos = 0;
    protected List childBreaks = new ArrayList();

    public void setFObj(FObj fo) {
        super.setFObj(fo);
        this.childLMiter = new BlockLMiter(this.childLMiter);
    }

    public void setBlockTextInfo(TextInfo ti) {
        this.lead = ti.fs.getAscender();
        this.follow = ti.fs.getDescender();
        this.lineHeight = ti.lineHeight;
    }

    protected void initProperties(PropertyManager pm) {
        this.layoutProps = pm.getLayoutProps();
        this.borderProps = pm.getBorderAndPadding();
        this.backgroundProps = pm.getBackgroundProps();
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext context) {
        LayoutProcessor curLM;
        int ipd = context.getRefIPD();
        MinOptMax stackSize = new MinOptMax();
        stackSize.add(this.layoutProps.spaceBefore.getSpace());
        BreakPoss lastPos = null;
        while ((curLM = this.getChildLM()) != null) {
            void var2_5;
            LayoutContext childLC = new LayoutContext(0);
            if (var2_5.generatesInlineAreas()) {
                childLC.setStackLimit(new MinOptMax(ipd));
                childLC.setRefIPD(ipd);
            } else {
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
                childLC.setRefIPD(ipd);
            }
            boolean over = false;
            while (!var2_5.isFinished()) {
                BreakPoss bp = var2_5.getNextBreakPoss(childLC);
                if (bp == null) continue;
                if (stackSize.opt + bp.getStackingSize().opt > context.getStackLimit().max) {
                    if (lastPos != null) {
                        LayoutProcessor lm = lastPos.getLayoutManager();
                        lm.resetPosition(lastPos.getPosition());
                        if (lm != var2_5) {
                            var2_5.resetPosition(null);
                        }
                    } else {
                        var2_5.resetPosition(null);
                    }
                    over = true;
                    break;
                }
                stackSize.add(bp.getStackingSize());
                lastPos = bp;
                this.childBreaks.add(bp);
                if (bp.nextBreakOverflows()) {
                    over = true;
                    break;
                }
                if (var2_5.generatesInlineAreas()) {
                    childLC.setStackLimit(new MinOptMax(ipd));
                    continue;
                }
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackSize));
            }
            if (this.getChildLM() != null && !over) continue;
            if (this.getChildLM() == null) {
                this.setFinished(true);
                stackSize.add(this.layoutProps.spaceAfter.getSpace());
            }
            BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, this.childBreaks.size() - 1));
            if (over) {
                breakPoss.setFlag(1024, true);
            }
            breakPoss.setStackingSize(stackSize);
            return breakPoss;
        }
        this.setFinished(true);
        BreakPoss breakPoss = new BreakPoss(new LeafPosition(this, -2));
        breakPoss.setStackingSize(stackSize);
        return breakPoss;
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        double adjust = layoutContext.getSpaceAdjust();
        this.addBlockSpacing(adjust, this.layoutProps.spaceBefore.getSpace());
        this.addID();
        this.addMarkers(true, true);
        LayoutContext lc = new LayoutContext(0);
        while (parentIter.hasNext()) {
            LayoutProcessor childLM;
            LeafPosition lfp = (LeafPosition)parentIter.next();
            if (lfp.getLeafPos() == -2) {
                this.curBlockArea = null;
                this.flush();
                return;
            }
            BreakPossPosIter breakPosIter = new BreakPossPosIter(this.childBreaks, this.iStartPos, lfp.getLeafPos() + 1);
            this.iStartPos = lfp.getLeafPos() + 1;
            while ((childLM = breakPosIter.getNextChildLM()) != null) {
                void var5_5;
                var5_5.addAreas(breakPosIter, lc);
            }
        }
        this.addMarkers(false, true);
        this.flush();
        this.addBlockSpacing(adjust, this.layoutProps.spaceAfter.getSpace());
        this.curBlockArea = null;
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            TraitSetter.addBorders(this.curBlockArea, this.borderProps);
            TraitSetter.addBackground(this.curBlockArea, this.backgroundProps);
            Area parentArea = this.parentLM.getParentArea(this.curBlockArea);
            int referenceIPD = parentArea.getIPD();
            this.curBlockArea.setIPD(referenceIPD);
            this.curBlockArea.setWidth(referenceIPD);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChild(Area childArea) {
        if (this.curBlockArea != null) {
            if (childArea instanceof LineArea) {
                this.curBlockArea.addLineArea((LineArea)childArea);
            } else {
                this.curBlockArea.addBlock((Block)childArea);
            }
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
            this.childBreaks.clear();
            this.iStartPos = 0;
        } else {
            LayoutProcessor layoutProcessor = resetPos.getLM();
        }
    }

    protected class BlockLMiter
    extends LMiter {
        private ListIterator proxy;

        public BlockLMiter(ListIterator pr) {
            super(null);
            this.proxy = pr;
        }

        protected boolean preLoadNext() {
            while (this.proxy.hasNext()) {
                LayoutProcessor lm = (LayoutProcessor)this.proxy.next();
                lm.setParent(BlockLayoutManager.this);
                if (lm.generatesInlineAreas()) {
                    LineLayoutManager lineLM = this.createLineManager(lm);
                    this.listLMs.add(lineLM);
                } else {
                    this.listLMs.add(lm);
                }
                if (this.curPos >= this.listLMs.size()) continue;
                return true;
            }
            return false;
        }

        protected LineLayoutManager createLineManager(LayoutManager firstlm) {
            ArrayList<LayoutManager> inlines = new ArrayList<LayoutManager>();
            inlines.add(firstlm);
            while (this.proxy.hasNext()) {
                LayoutProcessor lm = (LayoutProcessor)this.proxy.next();
                lm.setParent(BlockLayoutManager.this);
                if (lm.generatesInlineAreas()) {
                    inlines.add(lm);
                    continue;
                }
                this.proxy.previous();
                break;
            }
            LineLayoutManager child = new LineLayoutManager(BlockLayoutManager.this.lineHeight, BlockLayoutManager.this.lead, BlockLayoutManager.this.follow);
            child.setUserAgent(BlockLayoutManager.this.getUserAgent());
            child.setFObj(BlockLayoutManager.this.fobj);
            child.setLMiter(inlines.listIterator());
            return child;
        }
    }
}

