/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.traits.LayoutProps;

public class BreakPoss {
    public static final int CAN_BREAK_AFTER = 1;
    public static final int ISLAST = 2;
    public static final int ISFIRST = 4;
    public static final int FORCE = 8;
    public static final int CAN_BREAK_BEFORE = 16;
    public static final int HAS_ANCHORS = 64;
    public static final int ALL_ARE_SUPPRESS_AT_LB = 128;
    public static final int HYPHENATED = 256;
    public static final int REST_ARE_SUPPRESS_AT_LB = 512;
    public static final int NEXT_OVERFLOWS = 1024;
    private Position position;
    private MinOptMax stackSize;
    private int lead;
    private int total;
    private int middle;
    private MinOptMax nonStackSize;
    private long flags = 0L;
    private LayoutProps layoutProps = new LayoutProps();
    private SpaceSpecifier spaceSpecTrailing;
    private SpaceSpecifier spaceSpecLeading;

    public BreakPoss(Position position) {
        this(position, 0L);
    }

    public BreakPoss(Position position, long flags) {
        this.position = position;
        this.flags = flags;
    }

    public LayoutProcessor getLayoutManager() {
        return this.position.getLM();
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position pos) {
        this.position = pos;
    }

    public void setStackingSize(MinOptMax size) {
        this.stackSize = size;
    }

    public MinOptMax getStackingSize() {
        return this.stackSize;
    }

    public void setNonStackingSize(MinOptMax size) {
        this.nonStackSize = size;
    }

    public MinOptMax getNonStackingSize() {
        return this.nonStackSize;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlag(int flagBit) {
        this.setFlag(flagBit, true);
    }

    public void setFlag(int flagBit, boolean bSet) {
        this.flags = bSet ? (this.flags |= (long)flagBit) : (this.flags &= (long)(~flagBit));
    }

    public boolean isLastArea() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isFirstArea() {
        return (this.flags & 4L) != 0L;
    }

    public boolean canBreakAfter() {
        return (this.flags & 1L) != 0L;
    }

    public boolean canBreakBefore() {
        return (this.flags & 0x10L) != 0L;
    }

    public boolean couldEndLine() {
        return (this.flags & 0x200L) != 0L;
    }

    public boolean isForcedBreak() {
        return (this.flags & 8L) != 0L;
    }

    public boolean nextBreakOverflows() {
        return (this.flags & 0x400L) != 0L;
    }

    public boolean isSuppressible() {
        return (this.flags & 0x80L) != 0L;
    }

    public SpaceSpecifier getLeadingSpace() {
        return this.spaceSpecLeading;
    }

    public MinOptMax resolveLeadingSpace() {
        if (this.spaceSpecLeading != null) {
            return this.spaceSpecLeading.resolve(false);
        }
        return new MinOptMax(0);
    }

    public SpaceSpecifier getTrailingSpace() {
        return this.spaceSpecTrailing;
    }

    public MinOptMax resolveTrailingSpace(boolean bEndsRefArea) {
        if (this.spaceSpecTrailing != null) {
            return this.spaceSpecTrailing.resolve(bEndsRefArea);
        }
        return new MinOptMax(0);
    }

    public void setLeadingSpace(SpaceSpecifier spaceSpecLeading) {
        this.spaceSpecLeading = spaceSpecLeading;
    }

    public void setTrailingSpace(SpaceSpecifier spaceSpecTrailing) {
        this.spaceSpecTrailing = spaceSpecTrailing;
    }

    public LayoutProps getLayoutProps() {
        return this.layoutProps;
    }

    public int getLead() {
        return this.lead;
    }

    public int getTotal() {
        return this.total;
    }

    public int getMiddle() {
        return this.middle;
    }

    public void setLead(int ld) {
        this.lead = ld;
    }

    public void setTotal(int t) {
        this.total = t;
    }

    public void setMiddle(int t) {
        this.middle = t;
    }
}

