/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolveable;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.BreakPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;

public class ContentLayoutManager
implements LayoutProcessor {
    private FOUserAgent userAgent;
    private Area holder;
    private int stackSize;
    private LayoutProcessor parentLM;

    public ContentLayoutManager(Area area) {
        this.holder = area;
    }

    public void setFObj(FObj fo) {
    }

    public void fillArea(LayoutProcessor curLM) {
        int maxtb;
        ArrayList<BreakPoss> childBreaks = new ArrayList<BreakPoss>();
        MinOptMax stack = new MinOptMax();
        int ipd = 1000000;
        LayoutContext childLC = new LayoutContext(2);
        childLC.setLeadingSpace(new SpaceSpecifier(false));
        childLC.setTrailingSpace(new SpaceSpecifier(false));
        childLC.setStackLimit(new MinOptMax(ipd));
        childLC.setRefIPD(ipd);
        int lineHeight = 14000;
        int lead = 12000;
        int follow = 2000;
        int halfLeading = (lineHeight - lead - follow) / 2;
        int lineLead = lead + halfLeading;
        int middlefollow = maxtb = follow + halfLeading;
        while (!curLM.isFinished()) {
            MinOptMax lastSize = null;
            BreakPoss bp = curLM.getNextBreakPoss(childLC);
            if (bp != null) {
                lastSize = bp.getStackingSize();
                childBreaks.add(bp);
                if (bp.getLead() > lineLead) {
                    lineLead = bp.getLead();
                }
                if (bp.getTotal() > maxtb) {
                    maxtb = bp.getTotal();
                }
                if (bp.getMiddle() > middlefollow) {
                    middlefollow = bp.getMiddle();
                }
            }
            if (lastSize == null) continue;
            stack.add(lastSize);
        }
        if (maxtb - lineLead > middlefollow) {
            middlefollow = maxtb - lineLead;
        }
        LayoutContext lc = new LayoutContext(0);
        lc.setBaseline(lineLead);
        lc.setLineHeight(lineHeight);
        lc.setFlags(256, true);
        lc.setLeadingSpace(new SpaceSpecifier(false));
        lc.setTrailingSpace(new SpaceSpecifier(false));
        BreakPossPosIter breakPosIter = new BreakPossPosIter(childBreaks, 0, childBreaks.size());
        curLM.addAreas(breakPosIter, lc);
        this.stackSize = stack.opt;
    }

    public int getStackingSize() {
        return this.stackSize;
    }

    public boolean generatesInlineAreas() {
        return true;
    }

    public Area getParentArea(Area childArea) {
        return this.holder;
    }

    public void addChild(Area childArea) {
        this.holder.addChild(childArea);
    }

    public void setUserAgent(FOUserAgent ua) {
        this.userAgent = ua;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    protected Logger getLogger() {
        return this.userAgent.getLogger();
    }

    public void setParent(LayoutProcessor lm) {
        this.parentLM = lm;
    }

    public boolean canBreakBefore(LayoutContext lc) {
        return false;
    }

    public BreakPoss getNextBreakPoss(LayoutContext context) {
        return null;
    }

    public boolean isFinished() {
        return false;
    }

    public void setFinished(boolean isFinished) {
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
    }

    public void init() {
    }

    public void resetPosition(Position position) {
    }

    public void getWordChars(StringBuffer sbChars, Position bp1, Position bp2) {
    }

    public String getCurrentPageNumber() {
        return this.parentLM.getCurrentPageNumber();
    }

    public PageViewport resolveRefID(String ref) {
        return this.parentLM.resolveRefID(ref);
    }

    public void addIDToPage(String id) {
        this.parentLM.addIDToPage(id);
    }

    public void addUnresolvedArea(String id, Resolveable res) {
        this.parentLM.addUnresolvedArea(id, res);
    }

    public void addMarkerMap(Map marks, boolean start, boolean isfirst) {
        this.parentLM.addMarkerMap(marks, start, isfirst);
    }

    public Marker retrieveMarker(String name, int pos, int boundary) {
        return this.parentLM.retrieveMarker(name, pos, boundary);
    }
}

